<?php

if ( ! function_exists( 'kropp_core_add_banner_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_banner_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Banner_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_banner_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_Banner_Shortcode extends KroppCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'kropp_core_filter_banner_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'kropp_core_filter_banner_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/banner' );
			$this->set_base( 'kropp_core_banner' );
			$this->set_name( esc_html__( 'Banner', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds banner element', 'kropp-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);

			$options_map = kropp_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'kropp-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => 'simple-with-text',
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'image',
                    'name'       => 'hover_image',
                    'title'      => esc_html__( 'Hover Image', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'switch-image',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'prevent_revealing_on_hover',
                    'title'         => esc_html__( 'Prevent Text Revealing', 'kropp-core' ),
                    'description'   => esc_html__( 'Prevent text revealing on mobile and tablets. Useful when text is long and it can not fit container on smaller screens.', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'dependency'  => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'link-button',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'textarea',
                    'name'       => 'svg',
                    'title'      => esc_html__( 'SVG Icon', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'link-button',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'svg_size',
                    'title'       => esc_html__( 'SVG Size', 'kropp-core' ),
                    'group'       => esc_html__( 'SVG Icon Style', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'link-button',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link_url',
					'title'      => esc_html__( 'Link', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'kropp-core' ),
					'default_value' => esc_html__( 'Title Text', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => 'switch-image',
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'text',
                    'name'          => 'title_2',
                    'title'         => esc_html__( 'Title Line Bellow', 'kropp-core' ),
                    'default_value' => esc_html__( '', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h3',
					'group'         => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'kropp-core' ),
					'group'      => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'title_width',
                    'title'      => esc_html__( 'Title Max Width', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle',
					'title'      => esc_html__( 'Subtitle', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Subtitle Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'kropp-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle_margin_top',
					'title'      => esc_html__( 'Subtitle Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'outline',
                    'title'      => esc_html__( 'Outline', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'outline_font_size',
                    'title'      => esc_html__( 'Outline Font Size', 'kropp-core' ),
                    'group'         => esc_html__( 'Outline Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'outline_color',
                    'title'      => esc_html__( 'Outline Color', 'kropp-core' ),
                    'group'         => esc_html__( 'Outline Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'outline_margin_top',
                    'title'      => esc_html__( 'Outline Margin Top', 'kropp-core' ),
                    'group'         => esc_html__( 'Outline Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'outline_tag',
                    'title'         => esc_html__( 'Outline Tag', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
                    'default_value' => 'p',
                    'group'         => esc_html__( 'Outline Style', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => array( 'switch-image', 'link-button' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'text_field',
					'title'      => esc_html__( 'Text', 'kropp-core' ),
                    'dependency'   => array(
                        'hide' => array(
                            'layout' => array(
                                'values'        => 'switch-image',
                                'default_value' => '',
                            ),
                        ),
                    ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Text Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'kropp_core_button',
					'exclude'           => array( 'custom_class', 'link', 'target' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'kropp-core' ),
						'dependency'   => array(
							'show' => array(
								'layout' => array(
									'values'        => array('link-button','link-overlay'),
									'default_value' => '',
								),
							),
						),
					),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'background_color',
                    'title'      => esc_html__( 'Background Color', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'simple-with-text',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_holder',
                    'title'      => esc_html__( 'Padding', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_1440',
                    'title'      => esc_html__( 'Padding Bellow 1440', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_1366',
                    'title'      => esc_html__( 'Padding Bellow 1366', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_1024',
                    'title'      => esc_html__( 'Padding Bellow 1024', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_768',
                    'title'      => esc_html__( 'Padding Bellow 768', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'padding_680',
                    'title'      => esc_html__( 'Padding Bellow 680', 'kropp-core' ),
                    'dependency'   => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => array('simple-with-text','link-overlay'),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'skin',
                    'title'      => esc_html__( 'Skin', 'kropp-core' ),
                    'options'    => array(
                        ''      => esc_html__( 'Default', 'kropp-core' ),
                        'light' => esc_html__( 'Light', 'kropp-core' ),
                        'dark' => esc_html__( 'Dark', 'kropp-core' ),
                    ),
                )
            );

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
            $atts['unique_class']      = 'qodef-banner-' . rand( 0, 1000 );

			$atts['holder_classes']     = $this->get_holder_classes( $atts );
			$atts['title_styles']       = $this->get_title_styles( $atts );
			$atts['subtitle_styles']    = $this->get_subtitle_styles( $atts );
            $atts['outline_styles']     = $this->get_outline_styles( $atts );
			$atts['text_styles']        = $this->get_text_styles( $atts );
            $atts['background_styles']  = $this->get_background_styles( $atts );
            $atts['svg_styles']         = $this->get_svg_styles( $atts );
			$atts['button_params']      = $this->generate_button_params( $atts );
            $this->set_responsive_styles( $atts );

			return kropp_core_get_template_part( 'shortcodes/banner', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

            $holder_classes[] = $atts['unique_class'];
			$holder_classes[] = 'qodef-banner';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
            $holder_classes[] = ! empty ( $atts['prevent_revealing_on_hover'] ) && 'yes' === $atts['prevent_revealing_on_hover'] ? 'qodef--prevent-text-revealing-tablets' : '';
            $holder_classes[] = ! empty( $atts['skin'] ) ? 'qodef--' . $atts['skin'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

            if ( ! empty( $atts['title_width'] ) ) {
                $styles[] = 'max-width: ' . $atts['title_width'];
            }

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['subtitle_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['subtitle_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['subtitle_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

        private function get_background_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['background_color'] ) ) {
                $styles[] = 'background: ' . $atts['background_color'];
            }

            if ( ! empty( $atts['padding_holder'] ) ) {
                $styles[] = 'padding: ' . $atts['padding_holder'];
            }

            return $styles;
        }

        private function set_responsive_styles( $atts ) {
            $unique_class = '.' . $atts['unique_class'];
            $screen_sizes = array( '1440', '1366', '1024', '768', '680' );
            $option_keys  = array( 'padding' );

            foreach ( $screen_sizes as $screen_size ) {
                $styles = array();

                foreach ( $option_keys as $option_key ) {
                    $option_value = $atts[ $option_key . '_' . $screen_size ];
                    $style_key    = str_replace( '_', '-', $option_key );

                    if ( '' !== $option_value ) {
                        if ( qode_framework_string_ends_with_typography_units( $option_value ) ) {
                            $styles[ $style_key ] = $option_value . '!important';
                        } else {
                            $styles[ $style_key ] = intval( $option_value ) . 'px !important';
                        }
                    }
                }

                if ( ! empty( $styles ) ) {
                    add_filter(
                        'kropp_core_filter_add_responsive_' . $screen_size . '_inline_style_in_footer',
                        function ( $style ) use ( $unique_class, $styles ) {
                            $style .= qode_framework_dynamic_style( $unique_class, $styles );

                            return $style;
                        }
                    );
                }
            }
        }

        private function get_svg_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['svg_size'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['svg_size'] ) ) {
                    $styles[] = 'width: ' . $atts['svg_size'];
                } else {
                    $styles[] = 'width: ' . intval( $atts['svg_size'] ) . 'px';
                }
            }

            if ( ! empty( $atts['svg_color'] ) ) {
                $styles[] = 'color: ' . $atts['svg_color'];
            }

            return $styles;
        }

        private function get_outline_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['outline_margin_top'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['outline_margin_top'] ) ) {
                    $styles[] = 'margin-top: ' . $atts['outline_margin_top'];
                } else {
                    $styles[] = 'margin-top: ' . intval( $atts['outline_margin_top'] ) . 'px';
                }
            }

            if ( ! empty( $atts['outline_font_size'] ) ) {
                $styles[] = 'font-size: ' . $atts['outline_font_size'];
            }

            if ( ! empty( $atts['outline_color'] ) ) {
                $styles[] = '-webkit-text-stroke-color: ' . $atts['outline_color'];
            }

            return $styles;
        }

		private function generate_button_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'kropp_core_button',
					'exclude'        => array( 'custom_class', 'link', 'target' ),
					'atts'           => $atts,
				)
			);

			$params['link']   = ! empty( $atts['link_url'] ) ? $atts['link_url'] : '';
			$params['target'] = ! empty( $atts['link_target'] ) ? $atts['link_target'] : '';

			return $params;
		}
	}
}
