<?php

if ( ! function_exists( 'kropp_core_add_team_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function kropp_core_add_team_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();
		$has_single     = kropp_core_team_has_single();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'team' ),
				'type'  => 'meta',
				'slug'  => 'team',
				'title' => esc_html__( 'Team Single', 'kropp-core' ),
			)
		);

		if ( $page ) {
			$section = $page->add_section_element(
				array(
					'name'        => 'qodef_team_general_section',
					'title'       => esc_html__( 'General Settings', 'kropp-core' ),
					'description' => esc_html__( 'General information about team member.', 'kropp-core' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_team_single_layout',
						'title'       => esc_html__( 'Single Layout', 'kropp-core' ),
						'description' => esc_html__( 'Choose default layout for team single', 'kropp-core' ),
						'options'     => array(
							'' => esc_html__( 'Default', 'kropp-core' ),
						),
					)
				);
			}

            $section->add_field_element(
                array(
                    'field_type'  => 'text',
                    'name'        => 'qodef_team_member_title_line_break_positions',
                    'title'       => esc_html__( 'Positions of Line Break', 'kropp-core' ),
                    'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'kropp-core' ),
                )
            );

			$section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_team_member_role',
					'title'       => esc_html__( 'Role', 'kropp-core' ),
					'description' => esc_html__( 'Enter team member role', 'kropp-core' ),
				)
			);

			$social_icons_repeater = $section->add_repeater_element(
				array(
					'name'        => 'qodef_team_member_social_icons',
					'title'       => esc_html__( 'Social Networks', 'kropp-core' ),
					'description' => esc_html__( 'Populate team member social networks info', 'kropp-core' ),
					'button_text' => esc_html__( 'Add New Network', 'kropp-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'iconpack',
					'name'       => 'qodef_team_member_icon',
					'title'      => esc_html__( 'Icon', 'kropp-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_icon_link',
					'title'      => esc_html__( 'Icon Link', 'kropp-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_team_member_icon_target',
					'title'      => esc_html__( 'Icon Target', 'kropp-core' ),
					'options'    => kropp_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'date',
						'name'        => 'qodef_team_member_birth_date',
						'title'       => esc_html__( 'Birth Date', 'kropp-core' ),
						'description' => esc_html__( 'Enter team member birth date', 'kropp-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_email',
						'title'       => esc_html__( 'E-mail', 'kropp-core' ),
						'description' => esc_html__( 'Enter team member e-mail address', 'kropp-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_address',
						'title'       => esc_html__( 'Address', 'kropp-core' ),
						'description' => esc_html__( 'Enter team member address', 'kropp-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_education',
						'title'       => esc_html__( 'Education', 'kropp-core' ),
						'description' => esc_html__( 'Enter team member education', 'kropp-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'file',
						'name'        => 'qodef_team_member_resume',
						'title'       => esc_html__( 'Resume', 'kropp-core' ),
						'description' => esc_html__( 'Upload team member resume', 'kropp-core' ),
						'args'        => array(
							'allowed_type' => '[application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document]',
						),
					)
				);
			}

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_team_meta_box_map', $page, $has_single );
		}
	}

	add_action( 'kropp_core_action_default_meta_boxes_init', 'kropp_core_add_team_single_meta_box' );
}
