<?php

if ( ! function_exists( 'kropp_core_add_working_hours_widget' ) ) {
	/**
	 * function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_working_hours_widget( $widgets ) {
		$widgets[] = 'KroppCore_Working_Hours_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_working_hours_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Working_Hours_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'kropp_core_working_hours' );
			$this->set_name( esc_html__( 'Kropp Working Hours', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Use this widget to add a working hours info into widget area.', 'kropp-core' ) );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'kropp-core' ),
				)
			);
            $this->set_widget_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'working_hours_one_label',
                    'title'      => esc_html__( 'Working Hours One Label', 'kropp-core' ),
                )
            );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'working_hours_one',
					'title'      => esc_html__( 'Working Hours One', 'kropp-core' ),
				)
			);
            $this->set_widget_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'working_hours_two_label',
                    'title'      => esc_html__( 'Working Hours Two Label', 'kropp-core' ),
                )
            );
            $this->set_widget_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'working_hours_two',
                    'title'      => esc_html__( 'Working Hours Two', 'kropp-core' ),
                )
            );
		}

		public function render( $atts ) {
            $working_hours_one_label = ! empty( $atts['working_hours_one_label'] ) ? $atts['working_hours_one_label'] : esc_html__( 'Monday - Friday', 'kropp-core' );
            $working_hours_one       = $atts['working_hours_one'];
            $working_hours_two_label = ! empty( $atts['working_hours_two_label'] ) ? $atts['working_hours_two_label'] : esc_html__( 'Weekend', 'kropp-core' );
            $working_hours_two       = $atts['working_hours_two'];

        ?>
        <div class="widget qodef-working-hours-widget">
            <?php if ( ! empty( $working_hours_one ) ) { ?>
                <div class="qodef-working-hours-holder qodef-one">
                    <p class="qodef-working-hours-label qodef-one"><?php echo esc_html( $working_hours_one_label ); ?></p>
                    <p class="qodef-working-hours qodef-one"><?php echo esc_html( $working_hours_one ); ?></p>
                </div>
            <?php } ?>

            <?php if ( ! empty( $working_hours_two ) ) { ?>
                <div class="qodef-working-hours-holder qodef-two">
                    <p class="qodef-working-hours-label qodef-two"><?php echo esc_html( $working_hours_two_label ); ?></p>
                    <p class="qodef-working-hours qodef-two"><?php echo esc_html( $working_hours_two ); ?></p>
                </div>
            <?php } ?>
        </div>
        <?php
		}
	}
}
