<?php

if ( ! function_exists( 'kropp_core_add_bmi_calculator_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_bmi_calculator_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_BMI_Calculator_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_bmi_calculator_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_BMI_Calculator_Shortcode extends KroppCore_Shortcode {

		public function __construct() {
			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/bmi-calculator' );
			$this->set_base( 'kropp_core_bmi_calculator' );
			$this->set_name( esc_html__( 'BMI Calculator', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds BMI calculator', 'kropp-core' ) );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_bmi_chart',
					'title'      => esc_html__( 'Show BMI Chart', 'kropp-core' ),
					'options'    => kropp_core_get_select_type_options_pool( 'yes_no' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'chart_title',
					'title'      => esc_html__( 'BMI Chart Title', 'kropp-core' ),
					'dependency' => array(
						'show' => array(
							'show_bmi_chart' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'chart_title_background_text',
                    'title'      => esc_html__( 'Chart Title Background Text', 'kropp-core' ),
                    'dependency' => array(
                        'hide' => array(
                            'chart_title' => array(
                                'values'        => '',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'form_title',
					'title'      => esc_html__( 'Form Title', 'kropp-core' ),
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'title_color',
                    'title'      => esc_html__( 'Title Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'form_title_background_text',
                    'title'      => esc_html__( 'Form Title Background Text', 'kropp-core' ),
                    'dependency' => array(
                        'hide' => array(
                            'form_title' => array(
                                'values'        => '',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'background_text_outline_color',
                    'title'      => esc_html__( 'Background Text Outline Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'title_decoration',
                    'title'         => esc_html__( 'Title Decoration', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'group'         => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );

			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'form_description',
					'title'      => esc_html__( 'Form Description', 'kropp-core' ),
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'kropp_core_bmi_calculator', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {

			parent::render( $options );
			$atts = $this->get_atts();

			// fixed atts
            $atts['chart_title_tag'] = 'h2';
            $atts['form_title_tag']  = 'h2';

			$atts['holder_classes']          = $this->get_holder_classes( $atts );
            $atts['title_styles']            = $this->get_title_styles( $atts );
            $atts['title_background_styles'] = $this->get_title_background_styles( $atts );

			return kropp_core_get_template_part( 'shortcodes/bmi-calculator', 'templates/bmi-calculator', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-bmi-calculator';
            $holder_classes[] = ! empty( $atts['title_decoration'] ) ? 'qodef-title-decoration--' . $atts['title_decoration'] : '';
            $holder_classes[] = ! empty( $atts['show_bmi_chart'] ) ? 'qodef-show-bmi-chart--' . $atts['show_bmi_chart'] : '';
            $holder_classes[] = ! empty( $atts['chart_title'] ) ? 'qodef-show-bmi-chart-title--yes' : 'qodef-show-bmi-chart-title--no';

			return implode( ' ', $holder_classes );
		}

        private function get_title_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['title_color'] ) ) {
                $styles[] = 'color: ' . $atts['title_color'];
            }

            return $styles;
        }

        private function get_title_background_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['background_text_outline_color'] ) {
                $styles[] = '-webkit-text-stroke-color:' . $atts['background_text_outline_color'];
            }

            return $styles;
        }
	}
}
