<?php
$post_id       = get_the_ID();
$is_enabled    = kropp_core_get_post_value_through_levels( 'qodef_portfolio_single_enable_related_posts' );
$related_posts = kropp_core_get_custom_post_type_related_posts( $post_id, kropp_core_get_portfolio_single_post_taxonomies( $post_id ) );

if ( 'yes' === $is_enabled && ! empty( $related_posts ) && class_exists( 'KroppCore_Portfolio_List_Shortcode' ) ) { ?>
	<div id="qodef-portfolio-single-related-items">
        <h3 class="qodef-related-post-title">
            <?php esc_html_e('Related Posts','kropp-core'); ?>
        </h3>
		<?php
		$params = apply_filters(
			'kropp_core_filter_portfolio_single_related_posts_params',
			array(
				'custom_class'       => 'qodef--no-bottom-space',
				'columns'            => '4',
				'space'              => 'modest',
				'posts_per_page'     => 4,
				'additional_params'  => 'id',
				'post_ids'           => $related_posts['items'],
				'layout'             => 'info-on-hover',
				'title_tag'          => 'h4',
				'excerpt_length'     => '100',
                'is_related'         => 'yes',
                'columns_responsive' => 'custom',
                'columns_1440'       => 4,
                'columns_1366'       => 4,
                'columns_1024'       => 2,
                'columns_768'        => 2,
                'columns_680'        => 1,
                'columns_480'        => 1,
			)
		);

		echo KroppCore_Portfolio_List_Shortcode::call_shortcode( $params );
		?>
	</div>
<?php } ?>
