<?php

if ( ! function_exists( 'kropp_core_add_clients_meta_box' ) ) {
	/**
	 * Function that adds fields for clients
	 */
	function kropp_core_add_clients_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'clients' ),
				'type'  => 'meta',
				'slug'  => 'clients',
				'title' => esc_html__( 'Clients Parameters', 'kropp-core' ),
			)
		);

		if ( $page ) {

            $page->add_field_element(
                array(
                    'field_type'    => 'select',
                    'name'          => 'qodef_logo_source',
                    'title'         => esc_html__( 'Logo Source', 'kropp-core' ),
                    'options'       => array(
                        'image'    => esc_html__( 'Image', 'kropp-core' ),
                        'svg-path' => esc_html__( 'SVG Path', 'kropp-core' ),
                    ),
                    'default_value' => 'image',
                )
            );

            $page->add_field_element(
                array(
                    'field_type'  => 'textarea',
                    'name'        => 'qodef_logo_svg_path',
                    'title'       => esc_html__( 'Client Logo SVG Path', 'kropp-core' ),
                    'description' => esc_html__( 'Enter your logo icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'qodef_logo_source' => array(
                                'values'        => 'svg-path',
                                'default_value' => 'image',
                            ),
                        ),
                    ),
                )
            );

            $page->add_field_element(
                array(
                    'field_type'  => 'textarea',
                    'name'        => 'qodef_logo_hover_svg_path',
                    'title'       => esc_html__( 'Client Logo Hover SVG Path', 'kropp-core' ),
                    'description' => esc_html__( 'Enter your logo icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'qodef_logo_source' => array(
                                'values'        => 'svg-path',
                                'default_value' => 'image',
                            ),
                        ),
                    ),
                )
            );

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_logo_image',
					'title'      => esc_html__( 'Client Logo Image', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'qodef_logo_source' => array(
                                'values'        => 'image',
                                'default_value' => 'image',
                            ),
                        ),
                    ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_logo_hover_image',
					'title'      => esc_html__( 'Client Logo Hover Image', 'kropp-core' ),
                    'dependency' => array(
                        'show' => array(
                            'qodef_logo_source' => array(
                                'values'        => 'image',
                                'default_value' => 'image',
                            ),
                        ),
                    ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_client_link',
					'title'      => esc_html__( 'Client Link', 'kropp-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_client_link_target',
					'title'      => esc_html__( 'Client Link Target', 'kropp-core' ),
					'options'    => kropp_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_clients_meta_box_map', $page );
		}
	}

	add_action( 'kropp_core_action_default_meta_boxes_init', 'kropp_core_add_clients_meta_box' );
}
