<?php
/*
 * Archive Service
 */

defined('TEMPLAZA_FRAMEWORK');
use TemPlazaFramework\Functions;
use TemPlazaFramework\Templates;
use TemPlazaFramework\CSS;
$tzautoshowroom_id             = isset($atts['id'])?$atts['id']:time();
$tzautoshowroom_custom_class   = isset($atts['custom_container_class'])?' '.$atts['custom_container_class']:'';
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $tzautoshowroom_options = array();
}else{
    $tzautoshowroom_options            = Functions::get_theme_options();
}
global $wp_query;
$tzautoshowroom_post_type      = get_post_type(get_the_ID());

$prefix               = $tzautoshowroom_post_type.'-page';

if($tzautoshowroom_post_type == 'post'){
    $prefix = 'blog-page';
}
$tzautoshowroom_layout        = isset($tzautoshowroom_options[$prefix.'-layout'])?$tzautoshowroom_options[$prefix.'-layout']:'list';

$tzautoshowroom_grid_col      = isset($tzautoshowroom_options[$prefix.'-grid-column'])?$tzautoshowroom_options[$prefix.'-grid-column']:2;
$tzautoshowroom_col_gap      = isset($tzautoshowroom_options[$prefix.'-column-gap'])?$tzautoshowroom_options[$prefix.'-column-gap']:'collapse';
$tzautoshowroom_thumbnail_size= isset($tzautoshowroom_options[$prefix.'-thumbnail-size'])?$tzautoshowroom_options[$prefix.'-thumbnail-size']:'large';
$tzautoshowroom_thumbnail_effect = isset($tzautoshowroom_options[$prefix.'-thumbnail-effect'])?$tzautoshowroom_options[$prefix.'-thumbnail-effect']:'none';
$tzautoshowroom_leading      = isset($tzautoshowroom_options[$prefix.'-leading'])?filter_var($tzautoshowroom_options[$prefix.'-leading'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_thumbnail     = isset($tzautoshowroom_options[$prefix.'-thumbnail'])?filter_var($tzautoshowroom_options[$prefix.'-thumbnail'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_title         = isset($tzautoshowroom_options[$prefix.'-title'])?filter_var($tzautoshowroom_options[$prefix.'-title'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_description   = isset($tzautoshowroom_options[$prefix.'-description'])?filter_var($tzautoshowroom_options[$prefix.'-description'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_readmore      = isset($tzautoshowroom_options[$prefix.'-readmore'])?filter_var($tzautoshowroom_options[$prefix.'-readmore'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_share         = isset($tzautoshowroom_options[$prefix.'-share'])?filter_var($tzautoshowroom_options[$prefix.'-share'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_thumbnail_audio = isset($tzautoshowroom_options[$prefix.'-thumb-audio'])?filter_var($tzautoshowroom_options[$prefix.'-thumb-audio'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_thumbnail_video = isset($tzautoshowroom_options[$prefix.'-thumb-video'])?filter_var($tzautoshowroom_options[$prefix.'-thumb-video'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_thumbnail_link = isset($tzautoshowroom_options[$prefix.'-thumb-link'])?filter_var($tzautoshowroom_options[$prefix.'-thumb-link'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_thumbnail_quote = isset($tzautoshowroom_options[$prefix.'-thumb-quote'])?filter_var($tzautoshowroom_options[$prefix.'-thumb-quote'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_pagination = isset($tzautoshowroom_options[$prefix.'-pagination'])?filter_var($tzautoshowroom_options[$prefix.'-pagination'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_category      = isset($tzautoshowroom_options[$prefix.'-category'])?filter_var($tzautoshowroom_options[$prefix.'-category'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_tag           = isset($tzautoshowroom_options[$prefix.'-tag'])?filter_var($tzautoshowroom_options[$prefix.'-tag'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_image_cover           = isset($tzautoshowroom_options[$prefix.'-image-cover'])?filter_var($tzautoshowroom_options[$prefix.'-image-cover'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_thumbnail_height = isset($tzautoshowroom_options[$prefix.'-thumbnail-height'])?$tzautoshowroom_options[$prefix.'-thumbnail-height']:300;
$tzautoshowroom_card_size = isset($tzautoshowroom_options[$prefix.'-card-size'])?$tzautoshowroom_options[$prefix.'-card-size']:'';
$tzautoshowroom_card_custom = isset($tzautoshowroom_options[$prefix.'-card-custom'])?$tzautoshowroom_options[$prefix.'-card-custom']:'';
$tzautoshowroom_cl = '';
if ($tzautoshowroom_layout == 'column' || $tzautoshowroom_layout == 'grid') {
    $tzautoshowroom_layout_cl = 'templaza-blog-grid uk-child-width-1-'.$tzautoshowroom_grid_col.'@m';
    $tzautoshowroom_cl = '';
}else{
    $tzautoshowroom_layout_cl = 'templaza-blog-list uk-child-width-1-1';
    $tzautoshowroom_cl = '';
}
$designs    = array(
    array(
        'enable'    => true,
        'class'     => '.templaza-archive-item .uk-card-body',
        'options' => array(
            'blog-page-card-custom',
        ),
    ),
);
if ( class_exists( 'TemPlazaFramework\TemPlazaFramework' ) ) {
    if (count($designs)) {
        $styles = array();

        foreach ($designs as $design) {
            $enable = isset($design['enable']) ? (bool)$design['enable'] : false;
            if ($enable) {
                $wd_css_responsive = array(
                    'desktop' => '',
                    'tablet' => '',
                    'mobile' => '',
                );
                $wd_css = Templates::make_css_design_style($design['options'], $tzautoshowroom_options);

                if (!empty($wd_css)) {
                    if (is_array($wd_css)) {
                        foreach ($wd_css as $device => $wd_style) {
                            if (!empty($wd_style)) {
                                $wd_style = $design['class'] . '{' . $wd_style . '}';
                                Templates::add_inline_style($wd_style, $device);
                            }
                        }
                    } else {
                        Templates::add_inline_style($design['class'] . '{' . $wd_css . '}');
                    }
                }
            }
        }
    }
    if ($tzautoshowroom_image_cover == true) {
        $tzautoshowroom_css = '.templaza-blog-item-img a, .uk-slideshow-items,
     .templaza-blog-item-video .tz-embed-responsive {height: ' . $tzautoshowroom_thumbnail_height . 'px;}';

        Templates::add_inline_style($tzautoshowroom_css);
    }
}
?>
<div id="templaza-archive-<?php echo esc_attr($tzautoshowroom_id);?>" class="templaza-blog templaza-archive templaza-archive-<?php echo esc_attr(get_post_type().$tzautoshowroom_custom_class); ?>">
    <div class="templaza-blog-body <?php echo esc_attr($tzautoshowroom_layout_cl. ' uk-grid-'.$tzautoshowroom_col_gap);?>" data-uk-grid>
        <?php
        $d=1;
        if($wp_query->found_posts==0){
            ?>
            <div class="templaza-blog-item">
                <?php
                do_action('templaza_archive_no_result');
                ?>
            </div>
            <?php
        }
        if (have_posts()) : while (have_posts()) : the_post();
            $format = get_post_format() ? : 'standard';
            if(is_sticky(get_the_ID())){
                $sticky_cl = 'templaza-sticky';
            }else{
                $sticky_cl = '';
            }
            if($tzautoshowroom_leading && $d==1 && $tzautoshowroom_layout=='grid'){
                $lead = 'uk-width-1-1';
                $wrap_lead_content = 'templaza-item-lead';
            }else{
                $lead = $wrap_lead_content = ' ';
            }
            ?>
            <div id='post-<?php the_ID(); ?>' class="<?php echo esc_attr($tzautoshowroom_cl. ' '.$sticky_cl.' '.$lead); ?> templaza-blog-item ">
                <div class="templaza-blog-item-wrap templaza-archive-item uk-position-relative <?php echo esc_attr($wrap_lead_content);?>">
                    <?php
                    if(is_sticky(get_the_ID()) && has_post_thumbnail()){
                        ?>
                        <span class="templaza-sticky-post" title="<?php echo esc_attr__('Sticky Post','tzautoshowroom');?>"><i class="fas fa-thumbtack"></i></span>
                        <?php
                    }
                    if ($tzautoshowroom_show_thumbnail){
                        if ($format == 'gallery' && has_post_thumbnail()) {
                            do_action('templaza_image_post');
                        }
                        if($format == 'standard'){
                            do_action('templaza_image_post');
                        }
                        if ($format =='video' && has_post_thumbnail()) {
                            if ($tzautoshowroom_show_thumbnail_video){
                                do_action('templaza_image_post');
                            }else{
                                do_action('templaza_video_post');
                            }
                        }
                        if ($format =='audio' && has_post_thumbnail()){
                            if ($tzautoshowroom_show_thumbnail_audio){
                                do_action('templaza_image_post');
                            }else{
                                do_action('templaza_audio_post');
                            }
                        }
                        if ($format =='link' && has_post_thumbnail()){
                            if ($tzautoshowroom_show_thumbnail_link){
	                            do_action('templaza_image_post');
                            } else {
                                do_action('templaza_link_post');
                            }
                        }
                        if ($format == 'quote' && has_post_thumbnail()){
                            if ($tzautoshowroom_show_thumbnail_quote){
	                            do_action('templaza_image_post');
                            } else {
                                do_action('templaza_quote_post');
                            }
                        }
                    }
                        ?>
                    <div class="templaza-blog-item-content <?php echo esc_attr($wrap_lead_content);?>">
                        <?php
                        if ($tzautoshowroom_show_title) {
                            do_action('templaza_title_post');
                        }
                        do_action('templaza_meta_post_header');

                        if ($tzautoshowroom_show_description) {
                            do_action('templaza_excerpt_post');
                        }
                        if($tzautoshowroom_show_share || $tzautoshowroom_show_readmore){
                            ?>
                            <div class="templaza-archive-share-box uk-flex uk-flex-between uk-flex-middle uk-child-width-1-2@s">
                                <?php
                                if ($tzautoshowroom_show_readmore) {
                                    do_action('templaza_readmore_post');
                                }
                                if ($tzautoshowroom_show_share) {
                                    do_action('templaza_share_post');
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>

                    </div>

                </div>
            </div>
            <?php
            $d++;
        endwhile; // end while ( have_posts )

        endif; // end if ( have_posts )
        ?>
    </div>
    <?php if($tzautoshowroom_show_pagination){?>
    <div class="templaza-blog-pagenavi uk-margin-top">
        <?php
        do_action('templaza_pagination');
        ?>
    </div>
    <?php } ?>
</div>