<?php
defined('TEMPLAZA_FRAMEWORK') or exit();
//require_once 'post-type/product/product.php';
//require_once 'post-type/ap_product/ap_product.php';
use TemPlazaFramework\Functions;
Templaza_API::add_field_arguments('settings', 'blog-page',
    array(
        'blog-page-layout' => array(
            'options' => array(
                'columns' => 'Columns',
                'list' => 'List',
                'grid' => 'Grid',
            )
        ),
    )
);
Templaza_API::set_fields('settings', 'blog-page',
    array(
        array(
            'id'       => 'blog-page-column-gap',
            'type'     => 'select',
            'title'    => esc_html__('Column Gap', 'tzautoshowroom'),
            'subtitle' => esc_html__('Column Gap grid.', 'tzautoshowroom'),
            'options'  => array(
                'default' => esc_html__('Default','tzautoshowroom'),
                'small' => esc_html__('Small','tzautoshowroom'),
                'medium' => esc_html__('Medium','tzautoshowroom'),
                'large' => esc_html__('Large','tzautoshowroom'),
                'collapse' => esc_html__('Collapse','tzautoshowroom'),
            ),
            'default'  => 'default',
            'required' => array('blog-page-layout', '=' , array('grid','columns'))
        ),
        array(
            'id'       => 'blog-page-card-size',
            'type'     => 'select',
            'title'    => esc_html__('Card Size', 'tzautoshowroom'),
            'options'  => array(
                'default' => esc_html__('Default','tzautoshowroom'),
                'small' => esc_html__('Small','tzautoshowroom'),
                'large' => esc_html__('Large','tzautoshowroom'),
                'custom' => esc_html__('Custom','tzautoshowroom'),
            ),
            'default'  => 'default',
            'required' => array('blog-page-layout', '=' , 'grid')
        ),
        array(
            'id'       => 'blog-page-card-custom',
            'type'     => 'spacing',
            'allow_responsive'    => true,
            'title'    => esc_html__('Card custom', 'tzautoshowroom'),
            'default'  => '',
            'required' => array('blog-page-card-size', '=' , 'custom')
        ),
        array(
            'id'       => 'blog-page-image-cover',
            'type'     => 'switch',
            'title'    => esc_html__( 'Cover image', 'tzautoshowroom' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog-page-thumbnail-height',
            'type'     => 'spinner',
            'title'    => esc_html__('Thumbnail height', 'tzautoshowroom'),
            'default'  => '300',
            'min'      => '100',
            'step'     => '1',
            'max'      => '1000',
            'required' => array('blog-page-image-cover', '=' , true)
        ),
    )
);


Templaza_API::set_fields('settings', 'miscellaneous-contact',
    array(
        array(
            'id'          => 'contact-register-icon',
            'type'        => 'select',
            'title'       => esc_html__( 'Register icon', 'tzautoshowroom' ),
            'data'        => 'fontawesome',
            'required'    => array( 'enable-contact', '=', true ),
        ),
        array(
            'id'       => 'contact-register',
            'type'     => 'text',
            'title'    => esc_html__( 'Register label', 'tzautoshowroom' ),
            'subtitle' => esc_html__( 'Enter your register label.', 'tzautoshowroom' ),
            'required' => array( 'enable-contact', '=', true ),
        ),
    )
);
Templaza_API::set_subsection('settings', 'colors',
    array(
        'title'      => esc_html__( 'Theme Color', 'tzautoshowroom' ),
        'id'         => 'colors-theme-color',
        'desc'       => esc_html__( 'Select colors for theme', 'tzautoshowroom' ),
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'theme-color',
                'type'     => 'color_rgba',
                'title'    => esc_html__( 'Theme color', 'tzautoshowroom' ),
                'subtitle' => esc_html__( 'Set the color of theme', 'tzautoshowroom' ),
            ),
        ),
    )
);