<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Template;
use DealerShip\DLS_Function;

global $post_id;

extract($args);

$fields = $instance -> get_fields();
?>
<div class="field_form">
    <?php
    if( is_array($fields) ){
        echo '<form method="post" id="dealership_register">';

        DLS_Template::load_my_layout('notice', true, false, array());

        do_action( "dealership_before_form", $args );

        $role_id    = isset($_REQUEST['id'])?$_REQUEST['id']:'';
        $options    = !empty($role_id)?get_option('dls_role_'.$role_id.'_meta'):array();

        foreach( $fields as $field ){

            // if they didn't select a type, skip this field
            if( !$field || !$field['type'] || $field['type'] == 'null' )
            {
                continue;
            }

            // apply filters
            $field = apply_filters('acf/load_field_defaults', $field);

            // set value
            if( !isset($field['value']))
            {
                $field['value'] = isset($options[$field['name']])?$options[$field['name']]:null;

                // Set field is true when role is administrator
                if($field['value'] == null && $role_id == 'administrator'){
                    $field['value'] = 1;
                }
            }

            // required
            $required_class = "";
            $required_label = "";

            if(!empty($field) && isset( $field['required']) && $field['required'] )
            {
                $required_class = ' required';
                $required_label = ' <span class="required">*</span>';
            }

            echo '<div id="acf-' . $field['name'] . '" class="field ap-register-item field_type-' . $field['type'] . ' field_key-' . $field['key'] . $required_class . '" data-field_name="' . $field['name'] . '" data-field_key="' . $field['key'] . '" data-field_type="' . $field['type'] . '">';

            echo '<div class="label">';
            echo '<label for="' . $field['id'] . '">' . $field['label'] . $required_label . '</label>';
            echo $field['instructions'];
            echo '</div>';

//            $field['name'] = '[' . $field['name'] . ']';
            do_action('acf/create_field', $field, $post_id);

            echo '</div>';

        }
        wp_nonce_field( 'dls_register_form' );;
        echo '<div class="dealer-register-button"><button class="templaza-btn uk-button uk-margin-top"><span>'.__('Register', 'dealership').'</span></button></div> ';

        do_action( 'dealership_after_form_fields', $args );
        echo '</form>';
    }
    ?>
</div>