<?php

defined('DEALERSHIP') or die();

use DealerShip\Interfaces\Notice;
use DealerShip\Interfaces\Session;

$notice = Notice::instance();

$enqueues   = $notice -> get_notices();

if(!empty($enqueues)){

    foreach($enqueues as $enqueue){

    $alert_type = isset($enqueue['type']) && !empty($enqueue['type'])?$enqueue['type']:'primary';
    switch ($enqueue['type']){
        case 'error':
            $alert_type = 'danger';
            break;
        case 'message':
            $alert_type = 'primary';
            break;
    }
?>
<div class="uk-alert-<?php echo $alert_type;?>" data-uk-alert>
    <a class="uk-alert-close" data-uk-close></a>
    <p><?php echo htmlspecialchars_decode($enqueue['message']);?></p>
</div>
<?php }
} ?>