<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Function;
use DealerShip\Helpers\QueryHelper;

extract($args);

global $wp;
?>
<ul class="uk-nav dealer-nav">
    <li class="<?php echo (isset($wp -> query_vars['dashboard']) || !QueryHelper::get_current_endpoint())?'uk-active':''; ?>">
        <a href="<?php echo get_permalink(); ?>"><?php _e('Dashboard', 'dealership');?></a>
    </li>
    <?php
    if(($menus = $instance -> get_navigations()) && !empty($menus)){
        $parent = '';
        foreach($menus as $key => $var){
            $endpoint   = QueryHelper::get_endpoint_name($var);
            $url        = QueryHelper::get_endpoint_url($endpoint);
            if($key == 'customer-logout'){
                $url    = wp_nonce_url($url, 'dls_customer-logout');
            }
            $item_next  = next($menus);

            $has_child  = $item_next && isset($item_next['parent']) && $item_next['parent'] == $key;
            $class  = isset($wp -> query_vars[$endpoint])?'uk-active':'';
            $class .= $has_child?' uk-parent':'';
            $class .= ' '.$key.'';
            if($key=='add-product'){
                $class .= ' templaza-btn';
            }
            ?>
        <li class="<?php echo $class; ?>">
            <a href="<?php echo esc_url($url); ?>">
                <?php
                    echo QueryHelper::get_endpoint_title($key);
                ?>
            </a>
        </li>
        <?php
        }
    }
    ?>
</ul>