<?php

defined('DEALERSHIP') or exit();

use DealerShip\DLS_Function;
use DealerShip\Helpers\Access;
use DealerShip\Helpers\QueryHelper;

$can_edit   = Access::authorise('_dls_can_edit_private');
$can_delete = Access::authorise('_dls_can_delete_private');

if($can_edit || $can_delete) {

    ?>
    <div class="dealer-pd-action uk-flex">
        <?php
            if($can_edit) {
                $edit_url = wp_nonce_url(add_query_arg(array('id' => get_the_ID()), QueryHelper::get_endpoint_url('edit-product')), 'edit-product');
                ?>
                <a href="<?php echo $edit_url; ?>" class="uk-icon-button" data-uk-icon="icon: pencil; ratio: 0.85"
                   data-uk-tooltip="<?php _e('Edit this product', 'dealership'); ?>">
                </a>
                <?php
            }
            if($can_delete) {
                $delete_url = wp_nonce_url(add_query_arg(array('id' => get_the_ID()), QueryHelper::get_endpoint_url('delete-product')), 'dls_delete_product');
                ?>
                    <a href="<?php echo $delete_url; ?>" class="uk-icon-button" data-uk-icon="icon: trash; ratio: 0.85"
                       data-uk-tooltip="<?php _e('Delete this product', 'dealership'); ?>">
                    </a>
                <?php
            }
        ?>
    </div>
    <?php
}
do_action('dealership/my-account/products/action');
?>