<?php

defined('DEALERSHIP') or die();

use DealerShip\DLS_Template;
use DealerShip\Helpers\QueryHelper;
use DealerShip\Helpers\ProductHelper;

if(QueryHelper::get_current_endpoint()){
    DLS_Template::load_my_layout('dealers.user_products_list', true, false, $args);
}else{
    $users  = get_users();

    if($users){

    ?>
        <div class=" ap-all-dealers uk-child-width-1-3" data-uk-grid>
        <?php foreach($users as $user){
            $avatar = get_avatar_url($user -> ID);
            $url    = get_permalink( get_the_ID()).$user -> user_login;
            $all_product = ProductHelper::get_total_by_user_id($user -> ID);
            ?>
            <div class="dealer-item">
                <div class="uk-card uk-card-default">
                    <div class="uk-card-body">
                        <div class="uk-grid-small uk-flex-middle uk-grid" data-uk-grid="">
                            <?php if(!empty($avatar)){?>
                            <div class="uk-width-auto uk-first-column">
                                <a href="<?php echo $url; ?>">
                                    <img class="uk-border-circle" src="<?php echo $avatar; ?>" width="100" height="100" alt="">
                                </a>
                            </div>
                            <?php } ?>
                            <div class="uk-width-expand">
                                <h3 class="uk-card-title ap-dealer-title uk-margin-remove-bottom">
                                    <a href="<?php echo $url; ?>"><?php echo $user -> get('display_name');?></a>
                                </h3>
                                <p class="uk-text-meta uk-margin-remove-top">
                                    <?php
                                    if($all_product == 1){
                                        echo sprintf(__('%s Product', 'dealership'), $all_product);
                                    }else{
                                        echo sprintf(__('%s Products', 'dealership'), $all_product);
                                    }
                                    ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        </div>
<?php
    }
}

