<?php

namespace DealerShip\TemplazaFramework;

use DealerShip\Interfaces\Base;

defined('DEALERSHIP') or die();

class TemplazaFrameworkFW extends Base {

    protected static $instance;

    public static function instance(){
        if(static::$instance){
            return static::$instance;
        }

        $instance   = new self();

        static::$instance   = $instance;
        return $instance;
    }

    public function hooks(){
        // Register element to layout in back-end
        add_filter('templaza-framework/field/tz_layout/after_load', array($this, 'add_element_to_layout'), 10, 2);

        // Register element on front-end
        add_action('templaza-framework/layout/generate/shortcode/init', array($this, 'register_element'));
    }

    public function add_element_to_layout($elements, $frame){
        $path   = DEALERSHIP_PATH.'/src/TemplazaFramework/Elements';
        $files  = glob($path.'/*.php');
        foreach($files as $file){
            $info = pathinfo($file);
            $file_name  = $info['filename'];

            if(!is_file($file)){
                $file   .= '/'.$file_name.'.php';
            }

//                $file_name  = basename($folder);
            $class_name = 'DealerShip\TemplazaFramework\Elements\\'.ucfirst(str_replace('-', '_', $file_name));
//                var_dump($file);
//                var_dump($class_name);

            if(class_exists($class_name)){
                $element    = new $class_name($frame -> field, '', $frame -> parent);
                $elements[$file_name]    = $element;
//                    $page_obj  = \call_user_func(array($class_name, 'instance'));
//                    $this -> pages[$file_name] = $page_obj;
            }
        }
//            var_dump($elements);
//            die(__FILE__);
        return $elements;
    }

    public function register_element($element){
        $path   = DEALERSHIP_PATH.'/src/TemplazaFramework/Elements';

        $files  = glob($path.'/*.php');
        foreach($files as $file){
            $info = pathinfo($file);
            $file_name  = $info['filename'];

            if(!is_file($file)){
                $file   .= '/'.$file_name.'.php';
            }
            if(strtolower($file_name) != $element['type']){
                continue;
            }

//                $file_name  = basename($folder);
            $class_name = 'DealerShip\TemplazaFramework\Elements\\'.ucfirst(str_replace('-', '_', $file_name));
//                var_dump($file);
//                var_dump(class_exists($class_name));

            if(class_exists($class_name)){
                $element    = new $class_name();
//                $elements[$file_name]    = $element;
//                    $page_obj  = \call_user_func(array($class_name, 'instance'));
//                    $this -> pages[$file_name] = $page_obj;
            }
        }
    }

}