<?php

namespace DealerShip\TemplazaFramework\Interfaces;

defined('DEALERSHIP') or exit();

class Element extends \TemplazaFramework_ShortCode{

    public function __construct($field_parent = array(), $value = '', $parent = '')
    {
        $this -> hooks();

        parent::__construct($field_parent, $value, $parent);
    }

    public function get_shortcode_name()
    {
        $name   = parent::get_shortcode_name(); // TODO: Change the autogenerated stub

        return $name;
    }

    public function hooks(){
        add_filter('templaza-framework/shortcode/'.$this -> get_name().'/tmpl', array($this, 'get_tmpl_file'));
    }

    public function get_name(){
        $class_name = get_called_class();

        $reflector  = new \ReflectionClass($class_name);
        $meta_name  = $reflector -> getShortName();

        return strtolower($meta_name);
    }

    public function get_tmpl_file($file){
        $file_name  = $this -> get_shortcode_name();
        $file_path  = DEALERSHIP_TEMPLAZA_FRAMEWORK_TEMPLATE_PATH.'/elements/'.$file_name.'.php';

        if(!file_exists($file_path)){
            $file_path  = DEALERSHIP_TEMPLATE_PATH.'/templaza-framework/elements/'.$file_name.'.php';
        }

        if(file_exists($file_path)){
            $file   = $file_path;
        }

        return $file;
    }

//    public function shortcode($atts, $content = ''){
//
//        die(__FILE__);
//    }
}