<?php

namespace DealerShip\Interfaces;

defined('DEALERSHIP') or exit();

class Template extends Base{

    protected $layout               = '';
    protected $layout_type          = '';
    protected $default_layout       = '';
    protected $default_layout_type  = '';

    public function set_layout($layout){
        $this -> layout = $layout;
    }

    public function get_layout($default_layout = ''){
        $default_layout    = !empty($default_layout)?$default_layout:$this -> default_layout;
        return !empty($this -> layout)?$this -> layout:$default_layout;
    }

    public function set_layout_type($layout_type){
        $this -> layout_type = $layout_type;
    }

    public function get_layout_type($default_layout_type = ''){

        $default_layout_type    = !empty($default_layout_type)?$default_layout_type:$this -> default_layout_type;

        return !empty($this -> layout_type)?$this -> layout_type:$default_layout_type;
    }

    public function render_template($require_once = true){

//        $partial    = !empty($partial)?str_replace('.', '/', $partial):'';

        $layout = $this -> get_layout();

        $path   = $this -> _get_template($layout, $this -> get_layout_type());

        if(file_exists($path)) {
            return $require_once?require_once $path:require $path;
        }
        return false;
    }

    protected function _get_template($layout = '', $layout_type = '', $admin = false){

        $layout = !empty($layout)?$layout:$this -> default_layout;

        if(empty($layout)){
            return false;
        }

        $layout = stripos($layout, '.php') !== false?$layout:$layout.'.php';

        $base_path  = $admin?DEALERSHIP_ADMIN_TEMPLATE_PATH:DEALERSHIP_TEMPLATE_PATH;
        $theme_path = \get_stylesheet_directory().'/'.DEALERSHIP.'/templates'.($admin?'/admin':'');

        if(!empty($layout_type)){
            $base_path  .= '/'.$layout_type;
            $theme_path .= '/'.$layout_type;
        }

        if(file_exists($theme_path.'/'.$layout)){
            return $theme_path.'/'.$layout;
        }elseif(file_exists($base_path.'/'.$layout)){
            return $base_path.'/'.$layout;
        }

        return false;
    }
}