<?php

namespace DealerShip\Interfaces;

defined('DEALERSHIP') or exit();

class Notice extends Base{

    protected $notice       = array();
    protected $enqueues     = array();
    protected $main_key     = 'dealership_notice';
    protected $enqueue_key  = 'dealership_notices';

    protected static $instance = false;

    public static function instance(){
        if(static::$instance){
            return static::$instance;
        }

        static::$instance = new self();

        return static::$instance;
    }

    /**
     * Set main message
     * @param string $message
     * @param string $type
     * */
    public function set_message($message, $type = 'message'){

        if(empty($message)){
           return;
        }

        $this -> notice = $notice = array('type' => $type,'message' => $message);
//        $this -> notice['type']    = $type;
//        $this -> notice['message'] = $message;

//        var_dump($notice); die(__METHOD__);

        $session    = Session::instance();
        $session -> set($this -> main_key, $notice);
    }

    /**
     * Get main message
     * @return bool|array
     * */
    public function get_message(){
        $session    = Session::instance();
        return $session -> get($this -> main_key);
    }

    /**
     * Get all messages
     * @return bool|array
     * */
    public function get_notices(){
        $enqueues   = array();
        $main_message = $this -> get_message();

        if(!empty($main_message)){
            $enqueues[] = $main_message;
        }

        $enqueue_message    = $this -> get_enqueue_messages();

        if(!empty($enqueue_message)){
            $enqueues   += $enqueue_message;
        }

        return $enqueues;
    }

    /**
     * Add message to enqueue
     * @param string $message
     * @praram string $type
     * */
    public function enqueue_message($message, $type = 'message'){

        if(empty($message)){
            return;
        }

        $session    = Session::instance();
        $enqueues   = $session -> get($this -> enqueue_key);

        $enqueues[] = array(
            'type'  => $type,
            'message'   => $message
        );

        $this -> enqueues   = $enqueues;

        $session -> set($this -> enqueue_key, $enqueues);
    }

    /**
     * Get enqueue messages (multiple message)
     * @return bool|array
     * */
    public function get_enqueue_messages(){
        $session    = Session::instance();
        return $session -> get($this -> enqueue_key);
    }

    public function clean_notices(){
        $session    = Session::instance();
        $session -> __unset($this -> main_key);
        $session -> __unset($this -> enqueue_key);
    }
}