<?php

namespace DealerShip\Interfaces;

use DealerShip\DLS_Function;

defined('DEALERSHIP') or exit();

class Metabox extends AdminTemplate {
    protected $default_layout       = 'base';
    protected $default_layout_type  = 'metaboxes';

    protected static $instances = array();

    public static $metabox_prefix   = DEALERSHIP_PREFIX;

    public function __construct()
    {
        parent::__construct();

        $this -> default_layout_type    .= '/'.$this -> get_name();

        $this -> _load_metabox();
    }

    public static function instance(){
//        if(static::$instances){
//            return static::$instances;
//        }

        $class_name = static::class;
        $name       = substr($class_name, strrpos($class_name, '\\')+1);
        $name       = strtolower($name);

        $instances  = &self::$instances;

        if(!isset($instances[$name])) {

            $instances[$name] = new $class_name();

//        $instance -> hooks();

//            static::$instances[$name] = $instance;
        }
        return $instances[$name];
    }

//    public function hooks(){
//        add_action('admin_init', array($this, '_load_metabox'));
//    }

    public function get_metabox_name(){
        $name   = $this -> get_name();

        return self::$metabox_prefix.'__'.$name;
    }

    public function render(){
        return $this -> render_template(false);
    }
//    public function render(){
//
////        $tab    = isset($_GET['tab'])?\sanitize_key( $_GET['tab'] ):'base';
//        $tab    = 'base';
//
//        $path   = $this -> _get_template($tab);
//
//        if(file_exists($path)) {
//            return require_once $path;
//        }
//        return false;
//    }

    public function _load_metabox(){

        $metabox  = $this->get_metabox_name();

        // Register post type to wordpress
        if(method_exists($this, 'register')) {
            $args   = $this -> register();

            if(!$args || !count($args)){
                return;
            }

            $title      = isset($args['title'])?$args['title']:$this -> get_name();
            $screen     = isset($args['screen'])?$args['screen']:'';
            $context    = isset($args['context'])?$args['context']:(isset($args['position'])?$args['position']:'');

            if(is_array($screen)){
                foreach($screen as $sc){
                    \add_meta_box($metabox, $title, array($this, 'render'), $sc,
                        $context, $args['priority']);
                }
            }else {
                add_meta_box($metabox, $title, array($this, 'render'), $screen,
                    $context, $args['priority']);
            }
            do_action('dealership/metabox/'.$metabox.'/registered', $metabox, $this);

        }
    }

//    protected function _get_template($layout = ''){
//
//        if(empty($layout)){
//            return false;
//        }
//
//        $layout = stripos($layout, '.php') !== false?$layout:$layout.'.php';
//
//        $base_path  = DEALERSHIP_ADMIN_TEMPLATE_PATH.'/metaboxes/'.$this -> get_name();
//        $theme_path = get_stylesheet_directory().'/'.DEALERSHIP.'/templates/admin/metaboxes/'.$this -> get_name();
//
//        if(file_exists($theme_path.'/'.$layout)){
//            return $theme_path.'/'.$layout;
//        }elseif(file_exists($base_path.'/'.$layout)){
//            return $base_path.'/'.$layout;
//        }
//
//        return false;
//    }

}