<?php

namespace DealerShip\Interfaces;

use DealerShip\DLS_Function;

defined('DEALERSHIP') or exit();

class Base{
    protected $text_domain;
    protected $cache    = array();

    public function __construct()
    {
        $this -> theme          = \wp_get_theme();
        $this -> text_domain    = DLS_Function::get_my_text_domain();

        if(method_exists($this, 'hooks')) {
            $this->hooks();
        }
    }

    public function get_name(){
        $class_name = get_called_class();

        $reflector  = new \ReflectionClass($class_name);
        $meta_name  = $reflector -> getShortName();

        return strtolower($meta_name);
    }

    public function get_property($name, $default = ''){
        if(isset($this -> {$name})){
            return $this -> {$name};
        }
        return $default;
    }

    protected function _get_store_id($args = array()){
        $_args      = \func_get_args();
        $store_id   = serialize($_args);

        return md5($store_id);
    }

}