<?php

namespace DealerShip\Helpers;

defined('DEALERSHIP') or die();

class UserRoleHelper
{
    protected static $cache = array();

    private static $choices = array();

    public static function get_roles($options = array())
    {
        $store_id   = __METHOD__;
        $store_id  .= '::'.serialize($options);
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        $roles      = array();
        $result     = array();
        $role_keys  = \get_option( 'dls_roles', array() );

        if ( $role_keys ) {
            foreach ( $role_keys as $role_key ) {
                $role_meta = \get_option( "dls_role_{$role_key}_meta" );
                if ( $role_meta ) {

                    $roles[ 'dls_' . $role_key ] = array(
                        'key'   => $role_key,
                        'users' => ! empty( $users_count['avail_roles'][ 'dls_' . $role_key ] ) ? $users_count['avail_roles'][ 'dls_' . $role_key ] : 0
                    );
                    $roles[ 'dls_' . $role_key ] = array_merge( $roles[ 'dls_' . $role_key ], $role_meta );

                    if(!isset($options['choice_has_prefix'])
                        || (isset($options['choice_has_prefix']) && $options['choice_has_prefix'])){
                        $result['dls_' .$role_key] = $role_meta['name'];
                    }else {
                        $result[$role_key] = $role_meta['name'];
                    }

                }
            }
        }

        if(!empty($result) && count($result)){
            return static::$cache[$store_id]   = $result;
        }

        return $result;
    }

    public static function get_role_choices($options = array()){
        static::$choices    = array();
        return $roles  = static::get_roles($options);
    }

    public static function get_user_role( $user_id ) {
        // User has roles so look for a UM Role one
//        $um_roles_keys = get_option( 'um_roles', array() );
        $roles_keys  = \get_option( 'dls_roles', array() );

        if ( empty( $roles_keys ) ) {
            return false;
        }

        $user = get_userdata( $user_id );

        if ( empty( $user->roles ) ) {
            return false;
        }

        $roles_keys = array_map( function( $item ) {
            return 'dls_' . $item;
        }, $roles_keys );

        $user_roles_array = array_intersect( $roles_keys, array_values( $user->roles ) );

        if ( empty( $user_roles_array ) ) {
            return false;
        }

        return array_shift( $user_roles_array );
    }

    public static function is_role_custom( $role ) {
        // User has roles so look for a UM Role one
        $role_keys = get_option( 'dls_roles', array() );

        if ( empty( $role_keys ) ) {
            return false;
        }

        $role_keys = array_map( function( $item ) {
            return 'dls_' . $item;
        }, $role_keys );

        return in_array( $role, $role_keys );
    }

    public static function get_roles_without_role_custom(){

        global $wp_roles;

        $store_id   = __METHOD__;
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if(!$wp_roles){
            return array();
        }

        $all_roles  = $wp_roles -> roles;

        if(empty($all_roles)){
            return array();
        }

        $roles  = array_filter($all_roles, function($role_data){
            if(!isset($role_data['_dls_is_custom']) || !$role_data['_dls_is_custom']){
                return $role_data;
            }
        });

        return static::$cache[$store_id] = $roles;
    }

    public static function get_roles_choices_without_role_custom(){
        $roles  = static::get_roles_without_role_custom();

        $store_id   = __METHOD__;
        $store_id  .= '::'.serialize($roles);
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if(empty($roles)) {
            return array();
        }

        $roles = array_map(function ($role_data) {
            return $role_data['name'];
        }, $roles);

        return static::$cache[$store_id] = $roles;
    }
}