<?php

namespace DealerShip\Helpers;

use DealerShip\Interfaces\BaseHelper;

defined('DEALERSHIP') or die();

class QueryHelper extends BaseHelper {
    protected $query_vars = array();

    public function __construct()
    {
        parent::__construct();

        $this -> query_vars = array(
            'products'          => array(
                'slug'  => 'products',
                'title' => __('Products', 'dealership')
            ),

            'edit-product'          => array(
                'slug'      => 'edit-product',
                'title'     => __('Edit Product', 'dealership'),
                'parent'    => 'products',
                'level'     => 1,
                'navigation'=> false
            ),
            'delete-product'          => array(
                'slug'      => 'delete-product',
                'title'     => __('Delete Product', 'dealership'),
                'parent'    => 'products',
                'level'     => 1,
                'navigation'=> false
            ),
            'edit-account'      => array(
                'slug'  => 'dls_edit-account',
                'title' => __('Account Detail', 'dealership')
            ),
            'dealers'   => array(
                'slug'  => 'dealers',
                'title' => __('Dealers', 'dealership'),
                'navigation'=> false
            ),
            'customer-logout'   => array(
                'slug'  => 'customer-logout',
                'title' => __('Logout', 'dealership')
            ),
            'add-product'          => array(
                'slug'  => 'add-product',
                'title' => __('Add Product', 'dealership'),
            ),
        );
    }

    public static function get_query_vars(){
        $helper = static::instance();
        $query_vars = apply_filters('dealership/queryhelper/query_vars',$helper -> query_vars);

        return $query_vars;
    }

    public static function get_endpoint_name($query_var){
        $endpoint_name  = is_array($query_var) && isset($query_var)?$query_var['slug']:$query_var;
        return $endpoint_name;
    }

    /**
     * Get query current active query var.
     *
     * @return string
     */
    public static function get_current_endpoint() {
        global $wp;

        foreach ( static::get_query_vars() as $key => $value ) {
            $endpoint = static::get_endpoint_name($value);
            if ( isset( $wp->query_vars[ $endpoint ] ) ) {
                return $endpoint;
            }
        }
        return '';
    }

    /**
     * Get query current active query var.
     *
     * @return string
     */
    public static function get_current_endpoint_key() {
        global $wp;

        foreach ( static::get_query_vars() as $key => $value ) {
            $endpoint = static::get_endpoint_name($value);
            if ( isset( $wp->query_vars[ $endpoint ] ) ) {
                return $key;
            }
        }
        return '';
    }

    /**
     * Endpoint mask describing the places the endpoint should be added.
     *
     * @since 2.6.2
     * @return int
     */
    public static function get_endpoints_mask() {
        if ( 'page' === \get_option( 'show_on_front' ) ) {
            $page_on_front     = \get_option( 'page_on_front' );
            if(is_plugin_active('advanced-product/advanced-product.php') && function_exists('get_field')){
                $myaccount_page_id = \get_field('dealership_myaccount_page_id', 'option');
            }else{
                $myaccount_page_id = '';
            }


            if ( in_array( $page_on_front, array( $myaccount_page_id, $page_on_front ), true ) ) {
                return EP_ROOT | EP_PAGES;
            }
        }

        return EP_PAGES;
    }

    public static function get_endpoint_url( $endpoint, $value = '', $permalink = '' ) {

        $store_id   = self::_get_store_id($endpoint, $value, $permalink);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if ( ! $permalink ) {
            $permalink = static::get_main_permalink();
        }

        // Map endpoint to options.
        $query_vars = static::get_query_vars();
        $endpoint   = ! empty( $query_vars[ $endpoint ] ) ? $query_vars[ $endpoint ] : $endpoint;
        $endpoint   = is_array($endpoint)?$endpoint['slug']:$endpoint;

        if ( get_option( 'permalink_structure' ) ) {
            if ( strstr( $permalink, '?' ) ) {
                $query_string = '?' . wp_parse_url( $permalink, PHP_URL_QUERY );
                $permalink    = current( explode( '?', $permalink ) );
            } else {
                $query_string = '';
            }
            $url = trailingslashit( $permalink );

            if ( $value ) {
                $url .= trailingslashit( $endpoint ) . user_trailingslashit( $value );
            } else {
                $url .= user_trailingslashit( $endpoint );
            }

            $url .= $query_string;
        } else {
            $url = add_query_arg( $endpoint, $value, $permalink );
        }

        $url    = apply_filters( 'dealership_get_endpoint_url', $url, $endpoint, $value, $permalink );
        $url    = trim($url);
        $url    = preg_replace('/\/+$/', '', $url);

        if(!empty($url)){
            return static::$cache[$store_id] = $url;
        }

        return '';
    }

    public static function get_endpoint_title( $endpoint, $action = '' ) {

        $store_id   = self::_get_store_id($endpoint, $action);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        $endpoint   = is_array($endpoint)?$endpoint['slug']:$endpoint;

        $query_vars = static::get_query_vars();

        $query_var  = isset($query_vars[$endpoint])?$query_vars[$endpoint]:array();

        if(is_array($query_var) && isset($query_var['title'])){
            return static::$cache[$store_id]    = $query_var['title'];
        }elseif(!empty($query_var)){
            return static::$cache[$store_id]    = $query_var;
        }
        return '';
    }

    public static function get_endpoint_layout(){

        $endpoint   = static::get_current_endpoint();
        $query_vars = static::get_query_vars();

        $store_id   = static::_get_store_id($endpoint, $query_vars);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if(empty($query_vars)){
            return '';
        }

        $layout = 'dashboard';

        foreach($query_vars as $key => $var){
            $slug   = $var;
            if(is_array($var) && isset($var['slug'])){
                $slug   = $var['slug'];
            }

            if(!empty($slug) && $slug == $endpoint){
                $layout = $key;
                break;
            }
        }

        if(!empty($layout)){
            return static::$cache[$store_id]    = $layout;
        }

        return '';
    }

    public static function get_main_permalink($post = 0){
//        var_dump(get_field('dealership_myaccount_page_id', false));
//        var_dump(get_option('options_dealership_myaccount_page_id'));
//        die(__FILE__);

        if(!is_numeric($post) && is_object($post) && isset($post -> ID)){
            $post   = $post -> ID;
        }

        $post   = $post == 0?(int)get_option('options_dealership_myaccount_page_id',0):$post;

        $fallback = null;
        $permalink = 0 < $post ? get_permalink( $post ) : '';

        if ( ! $permalink ) {
            $permalink = is_null( $fallback ) ? get_home_url() : $fallback;
        }

        return $permalink;
    }
}