<?php

namespace DealerShip\Helpers;

defined('DEALERSHIP') or die();

class Access{
    protected static $cache    = array();

    public static function get_actions($role){

        $store_id   = __METHOD__;
        $store_id  .= '::'.$role;
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        $dls_roles_keys = UserRoleHelper::get_roles();
        $dls_roles_keys = !empty($dls_roles_keys)?array_keys($dls_roles_keys):array();

        if(!in_array($role, $dls_roles_keys)){
            return false;
        }
        $role   = preg_replace('/^('.DEALERSHIP_PREFIX.'_)/i', '$1role_', $role);
        $option = \get_option($role.'_meta');

//        $option = \get_option(DEALERSHIP_PREFIX.'_role_'.$role.'_meta');

        if(!$option){
            return false;
        }

//        if(isset($option[$role])){
//            $role_action = filter_var($option[$role], FILTER_VALIDATE_BOOLEAN);
//            static::$cache[$store_id]   = $role_action;
//            return $role_action;
//        }

        return static::$cache[$store_id]   = $option;

//        return false;
    }

//    public static function get($action, $default = null){
//        $store_id   = __METHOD__;
//        $store_id  .= '::'.$action;
//        $store_id  .= '::'.$default;
//        $store_id   = md5($store_id);
//
//        if(isset(static::$cache[$store_id])){
//            return static::$cache[$store_id];
//        }
//
//        $role_action    = static::get_actions();
//    }

    public static function authorise($action, $default = false, $role = null){
        $store_id   = __METHOD__;
        $store_id  .= '::'.$action;
        $store_id  .= '::'.$role;
        $store_id   = md5($store_id);

        if(isset(static::$cache[$store_id])){
            return static::$cache[$store_id];
        }

        if ( !function_exists('wp_get_current_user') ) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }

        $user       = wp_get_current_user();
        $roles      = $user -> roles;

        if(!count($roles)){
            return false;
        }

        $access = $default;

        foreach ($roles as $_role){
            // Get actions of role
            $role_actions   = static::get_actions($_role);

            if($role_actions && isset($role_actions[$action])){
                if($action == '_dls_product_status'){
                    $access = $role_actions[$action];
                }else{
                    $_access    = filter_var($role_actions[$action], FILTER_VALIDATE_BOOLEAN);
                    if($access == null){
                        $access = $_access;
                    }
                    if($access != null && $_access){
                        $access = $_access;
                        break;
                    }
                }

            }elseif($_role == 'administrator'){
                $access = true;
            }
        }

        return $access;

    }
}