<?php
namespace  DealerShip\Frontend\EndPoints;

use DealerShip\Helpers\QueryHelper;
use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\EndPoint;
use DealerShip\Interfaces\Notice;

defined('DEALERSHIP') or exit();

class RegisterEP extends EndPoint {

    public function hooks(){
        add_action('wp_loaded', array($this, 'register'));
    }

    public function get_fields(){
        return $this -> register_fields();
    }

    public function register_fields(){
//        $wpdef_role = get_option('default_role');
//
//        $choices    = array(
//            $wpdef_role => ucfirst(ucfirst($wpdef_role))
//        );
        $choices    = UserRoleHelper::get_role_choices(array('choice_has_prefix' => true));

        $choices    = array_merge(array('' => __('- Select Role -', 'dealership')), $choices);
        return array(
            array(
                'key'   => 'field_62bd6df3befb0',
                'name'  => 'username',
                'type'  => 'text',
                'label' => __('Username', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb312249249',
                'name'  => 'first_name',
                'type'  => 'text',
                'label' => __('First Name', 'dealership'),
            ),
            array(
                'key'   => 'field_62eb313bef1e2',
                'name'  => 'last_name',
                'type'  => 'text',
                'label' => __('Last Name', 'dealership'),
            ),
            array(
                'key'   => 'field_62bd762b82b06',
                'name'  => 'password',
                'type'  => 'password',
                'label' => __('Password', 'dealership'),
            ),
            array(
                'key'   => 'field_62bd762b82b06',
                'name'  => 'confirm_password',
                'type'  => 'password',
                'label' => __('Confirm password', 'dealership'),
            ),
            array(
                'key'   => 'field_62bd767aa0b16',
                'name'  => 'user_email',
                'type'  => 'email',
                'required' => true,
                'label' => __('Email', 'dealership'),
            ),
            array(
                'type'	=>	'select',
                'name'	=>	'role',
                'choices'	=>	$choices,
                'label' => __('Account Type', 'dealership'),
            )
        );
    }

    public function register(){

        if(!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'dls_register_form')) {
            return false;
        }
        $args   = $_POST;

        /**
         * UM hook
         *
         * @type filter
         * @title um_add_user_frontend_submitted
         * @description Extend user data on registration form submit
         * @input_vars
         * [{"var":"$submitted","type":"array","desc":"Registration data"}]
         * @change_log
         * ["Since: 2.0"]
         * @usage
         * add_filter( 'um_add_user_frontend_submitted', 'function_name', 10, 1 );
         * @example
         *
         * add_filter( 'um_add_user_frontend_submitted', 'my_add_user_frontend_submitted', 10, 1 );
         * function my_add_user_frontend_submitted( $submitted ) {
         *     // your code here
         *     return $submitted;
         * }
         *
         */
        $args = apply_filters( 'dealership_add_user_frontend_submitted', $args );

        extract( $args );

        if ( ! empty( $username ) && empty( $user_login ) ) {
            $user_login = $username;
        }

//            if ( ! empty( $first_name ) && ! empty( $last_name ) && empty( $user_login ) ) {
//
//                switch ( UM()->options()->get( 'permalink_base' ) ) {
//                    case 'name':
//                        $user_login = str_replace( " ", ".", $first_name . " " . $last_name );
//                        break;
//
//                    case 'name_dash':
//                        $user_login = str_replace( " ", "-", $first_name . " " . $last_name );
//                        break;
//
//                    case 'name_plus':
//                        $user_login = str_replace( " ", "+", $first_name . " " . $last_name );
//                        break;
//
//                    default:
//                        $user_login = str_replace( " ", "", $first_name . " " . $last_name );
//                        break;
//                }
//                $user_login = sanitize_user( strtolower( remove_accents( $user_login ) ), true );
//
//                if ( ! empty( $user_login ) ) {
//                    $count = 1;
//                    $temp_user_login = $user_login;
//                    while ( username_exists( $temp_user_login ) ) {
//                        $temp_user_login = $user_login . $count;
//                        $count++;
//                    }
//                    $user_login = $temp_user_login;
//                }
//            }

        if ( empty( $user_login ) && ! empty( $user_email ) ) {
            $user_login = $user_email;
        }

        $unique_userID = uniqid();

        // see dbDelta and WP native DB structure user_login varchar(60)
        if ( empty( $user_login ) || mb_strlen( $user_login ) > 60 && ! is_email( $user_login ) ) {
            $user_login = 'user' . $unique_userID;
            while ( username_exists( $user_login ) ) {
                $unique_userID = uniqid();
                $user_login = 'user' . $unique_userID;
            }
        }

        if ( isset( $username ) && is_email( $username ) ) {
            $user_email = $username;
        }

        if ( ! isset( $password ) ) {
            $password = \wp_generate_password( 8 );
        }

        if ( empty( $user_email ) ) {
            $site_url = @$_SERVER['SERVER_NAME'];
            $user_email = 'nobody' . $unique_userID . '@' . $site_url;
            while ( email_exists( $user_email ) ) {
                $unique_userID = uniqid();
                $user_email = 'nobody' . $unique_userID . '@' . $site_url;
            }
            /**
             * UM hook
             *
             * @type filter
             * @title um_user_register_submitted__email
             * @description Change user default email if it's empty on registration
             * @input_vars
             * [{"var":"$user_email","type":"string","desc":"Default email"}]
             * @change_log
             * ["Since: 2.0"]
             * @usage
             * add_filter( 'um_user_register_submitted__email', 'function_name', 10, 1 );
             * @example
             *
             * add_filter( 'um_user_register_submitted__email', 'my_user_register_submitted__email', 10, 1 );
             * function my_user_register_submitted__email( $user_email ) {
             *     // your code here
             *     return $user_email;
             * }
             *
             */
            $user_email = apply_filters( 'dealership_user_register_submitted__email', $user_email );
        }

        $credentials = array(
            'user_login'    => $user_login,
            'user_password' => $password,
            'user_email'    => trim( $user_email ),
        );

        // set timestamp
        $timestamp = current_time( 'timestamp' );
        $args['timestamp'] = $timestamp;

        $args = array_merge( $args, $credentials );

        //get user role from global or form's settings
        $user_role  = isset($args['role'])?$args['role']:'';

        $def_wp_role        = get_field('dealership_register_role', 'option');
        $def_dealer_role    = get_field('dealership_register_dealer_wp_role', 'option');

        $user_role = apply_filters( 'dealership_registration_user_role', $user_role, $args );

        $userdata = array(
            'user_login'    => $user_login,
            'user_pass'     => $password,
            'user_email'    => $user_email,
//            'role'          => $user_role,
        );

        if(empty($user_role) && !empty($def_wp_role)){
            $userdata['role']   = $def_wp_role;
        }elseif(!empty($user_role) && !empty($def_dealer_role)){
            $userdata['role']   = $def_dealer_role;
        }

        if(isset($args['first_name'])){
            $userdata['first_name'] = $args['first_name'];
        }

        if(isset($args['last_name'])){
            $userdata['last_name'] = $args['last_name'];
        }

        $notice = Notice::instance();
        // Can insert user
        $can_register   = apply_filters('dealership/register/pre_register_user', true);

        if(!$can_register){
            $notice -> set_message(__(' User registration is currently not allowed', 'dealership'), 'error');

            $permalink  = $this -> get_redirect_permalink();
            $permalink  = apply_filters('dealership/user/register/pre_redirect_permalink', $permalink);

            do_action('dealership/register/before_redirect_permalink', $permalink);

            wp_redirect($permalink);

            return false;
        }

        $user_id = wp_insert_user( $userdata );

        if($user_id && !is_wp_error($user_id)){
            if(!empty($def_dealer_role)){
                $user   = get_userdata($user_id);
                $user->add_role($user_role);
            }

            $status = get_field('dealership_register_dealer_status', 'option');
            $status = !empty($status)?$status:'pending';
            if(!empty($status)) {
                // Set user meta status (Pending)
                add_user_meta($user_id, 'dls_account_status', $status);
            }
        }

        $message    = __('Thank you for registering. You may now log in using the username and password you registered with.', 'dealership');
//        $message    = apply_filter('dealership');

        $notice -> set_message($message, 'success');

        do_action( 'dealership_user_register', $user_id, $args );

        return $user_id;
    }

}