<?php

namespace DealerShip;

use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\Base;
use DealerShip\Interfaces\Template;

defined('DEALERSHIP') or die();

class Frontend extends Template {

    protected $shortcodes   = array();

    public function __construct()
    {
        parent::__construct();

//        $this -> register_shortcodes();

    }

    protected function register_shortcodes(){
        $path   = DEALERSHIP_SHORTCODES_PATH;
        if(!$path || ($path && !is_dir($path))){
            return false;
        }

        $files  = glob($path.'/*.php');

        if(count($files)){
            foreach ($files as $file){
                $info = pathinfo($file);
                $file_name  = $info['filename'];

//                if(!is_file($file)){
//                    $file   .= '/'.$file_name.'.php';
//                }

                $class_name = 'DealerShip\ShortCodes\\'.ucfirst(str_replace('-', '_', $file_name));

                if(class_exists($class_name)){
                    $page_obj  = \call_user_func(array($class_name, 'instance'));
                    $this -> shortcodes[$file_name] = $page_obj;
                }
            }
        }
    }
}
