<?php

namespace DealerShip;

defined('DEALERSHIP') or exit();

class DLS_Template{
    protected static $cache         = array();

    public static function load_my_layout($partial, $load = true, $require_once = false, $args = array()){
        $args   = array_merge(
            array(
            'text_domain' => DLS_Function::get_my_text_domain()
        ), $args);

        $partial    = str_replace('.', '/', $partial);

        $located    = self::locate_my_template((array) $partial, $load, $require_once, $args);

        return $located;
    }

    public static function locate_my_template($template_names, $load = false, $require_once = true, $args = array()){
        $located        = '';
        $base           = DEALERSHIP.'/templates';
        $framework_path = DEALERSHIP_TEMPLAZA_FRAMEWORK_TEMPLATE_PATH;

        foreach ( (array) $template_names as &$template_name ) {
            if ( ! $template_name ) {
                continue;
            }
            $framework_name = $template_name;
            $template_name  = $base.'/'.$template_name;

            if(!preg_match('/\.php$/i', $template_name)){
                $template_name  .= '.php';
            }
            if(!preg_match('/\.php$/i', $framework_name)){
                $framework_name  .= '.php';
            }

            if ( file_exists( get_stylesheet_directory() . '/' . $template_name ) ) {
                $located = get_stylesheet_directory() . '/' . $template_name;
                break;
            } elseif ( file_exists( get_template_directory() . '/' . $template_name ) ) {
                $located = get_template_directory() . '/' . $template_name;
                break;
            } elseif ( file_exists( $framework_path.'/'.$framework_name ) ) {
                $located   = $framework_path.'/'.$framework_name;
                break;
            } elseif ( file_exists( DEALERSHIP_PLUGIN_DIR_PATH.'/'.$template_name ) ) {
                $located   = DEALERSHIP_PLUGIN_DIR_PATH.'/'.$template_name;
                break;
            }
        }

        if($load && $located != '') {
            load_template($located, $require_once, $args);
        }

        return $located;
    }
}