<?php

defined('DEALERSHIP') or exit();

global $current_screen;
$screen_id = $current_screen->id;

$data   = array();
$option = array();
global $wp_roles;

if ( ! empty( $_GET['id'] ) ) {

    // uses sanitize_title instead of sanitize_key for backward compatibility based on #906 pull-request (https://github.com/ultimatemember/ultimatemember/pull/906)
    // roles e.g. "潜水艦subs" with both latin + not-UTB-8 symbols had invalid role ID
    $role_id = sanitize_title( $_GET['id'] );

    $data = \get_option( DEALERSHIP_PREFIX. "_role_{$role_id}_meta" );

    if ( empty( $data['_dls_is_custom'] ) ) {
        $data['name'] = $wp_roles->roles[ $role_id ]['name'];
    }
}
?>

    <script type="text/javascript">
        jQuery( document ).ready( function() {
            postboxes.add_postbox_toggles( '<?php echo esc_js( $screen_id ); ?>' );
        });
    </script>

    <div class="wrap">
        <h2>
            <?php
            if ( 'add' === sanitize_key( $_GET['tab'] ) ) {
                esc_html_e( 'Add New Role', 'dealership');
            } elseif ( 'edit' === sanitize_key( $_GET['tab'] ) ) {
                esc_html_e( 'Edit Role', 'dealership' );
                $add_new_link = add_query_arg(
                    array(
                        'page' => 'dls_user_roles',
                        'tab'  => 'add',
                    ),
                    admin_url( 'admin.php' )
                );
                ?>
                <a class="add-new-h2" href="<?php echo esc_url( $add_new_link ); ?>">
                    <?php esc_html_e( 'Add New', 'dealership' ); ?>
                </a>
                <?php
            }
            ?>
        </h2>

        <?php
        if ( ! empty( $_GET['msg'] ) ) {
            switch ( sanitize_key( $_GET['msg'] ) ) {
                case 'a':
                    echo '<div id="message" class="updated fade"><p>' . __( 'User Role <strong>Added</strong> Successfully.', 'dealership' ) . '</p></div>';
                    break;
                case 'u':
                    echo '<div id="message" class="updated fade"><p>' . __( 'User Role <strong>Updated</strong> Successfully.', 'dealership' ) . '</p></div>';
                    break;
            }
        }

        if ( ! empty( $error ) ) { ?>
            <div id="message" class="error fade">
                <p><?php echo $error; ?></p>
            </div>
        <?php } ?>


        <form id="dls_edit_role" action="" method="post" id="post" name="post">
            <input type="hidden" name="<?php echo DEALERSHIP_PREFIX;?>__userroles[id]" value="<?php
            echo isset( $_GET['id'] ) ? esc_attr( sanitize_key( $_GET['id'] ) ) : '' ?>" />
            <?php if ( 'add' === sanitize_key( $_GET['tab'] ) ) { ?>
                <input type="hidden" name="<?php echo DEALERSHIP_PREFIX;?>__userroles[_dls_is_custom]" value="1" />
                <input type="hidden" name="dls_nonce" value="<?php
                echo esc_attr( wp_create_nonce( 'dls-add-role' ) ) ?>" />
            <?php } else { ?>
                <input type="hidden" name="<?php echo DEALERSHIP_PREFIX;?>__userroles[_dls_is_custom]" value="<?php
                echo ! empty( $data['_dls_is_custom'] ) ? 1 : 0 ?>" />
                <input type="hidden" name="dls_nonce" value="<?php echo esc_attr( wp_create_nonce( 'dls-edit-role' ) ) ?>" />
<!--                <input type="hidden" name="acf_nonce" value="--><?php //echo wp_create_nonce( 'input' ); ?><!--" />-->
            <?php } ?>
            <?php wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false ); ?>
            <div id="poststuff">
                <div id="post-body" class="metabox-holder columns-2">
                    <div id="post-body-content">
                        <div id="titlediv">
                            <div id="titlewrap">
                                <?php if ( 'add' === sanitize_key( $_GET['tab'] ) ) { ?>
                                    <label for="title" class="screen-reader-text"><?php _e( 'Title', 'dealership') ?></label>
                                    <input type="text" name="<?php echo DEALERSHIP_PREFIX;?>__userroles[name]" placeholder="<?php
                                    esc_attr_e( 'Enter Title Here', 'dealership');
                                    ?>" id="title" value="<?php echo isset( $data['name'] ) ? $data['name'] : '' ?>" />
                                <?php } else { ?>
                                    <span style="float: left;width:100%;"><?php echo isset( $data['name'] ) ? stripslashes( $data['name'] ) : '' ?></span>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <?php
//                    $object = array(
//                        'data'   => $data,
//                        'option' => $option,
//                    );
                    $object = array();
                    ?>

                    <div id="postbox-container-1" class="postbox-container">

<!--                        <div class="postbox">-->
<!--                            <h3 class="hndle"><span>--><?php //_e("Publish", 'dealership'); ?><!--</span></h3>-->
<!--                            <div class="inside">-->
<!--                                <input type="hidden" name="HTTP_REFERER" value="--><?php //echo isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:''; ?><!--" />-->
<!--                                <input type="submit" class="button button-primary" value="--><?php //_e("Update Role",$this -> text_domain); ?><!--" />-->
<!--                            </div>-->
<!--                        </div>-->
                        <?php
                        do_meta_boxes( 'dls_user_role_meta', 'side', $object ); ?>
                    </div>
                    <div id="postbox-container-2" class="postbox-container">
                        <?php do_meta_boxes( 'dls_user_role_meta', 'normal', $object ); ?>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <?php ?>