<?php

defined('DEALERSHIP') or exit();

global $post_id;
$fields = $this -> register_fields();
?>
<h3><?php echo esc_html__('Advanced Product', 'dealership')?></h3>
<div class="field_form">
    <table class="form-table">
        <tbody>
            <?php
            if( is_array($fields) ){
                $options    = array();
                $user_id    = isset($_REQUEST['user_id'])?$_REQUEST['user_id']:get_current_user_id();

                foreach( $fields as $field ){

                    // if they didn't select a type, skip this field
                    if( !$field || !$field['type'] || $field['type'] == 'null' )
                    {
                        continue;
                    }

                    // apply filters
                    $field = apply_filters('acf/load_field_defaults', $field);

                    // set value
                    if( !isset($field['value']))
                    {
//                        $field['value'] = isset($options[$field['name']])?$options[$field['name']]:null;
                        $field['value'] = get_field($field['name'], 'user_'.$user_id);
                    }

                    // required
                    $required_class = "";
                    $required_label = "";

                    if(!empty($field) && isset( $field['required']) && $field['required'] )
                    {
                        $required_class = ' required';
                        $required_label = ' <span class="required">*</span>';
                    }

                    echo '<tr id="acf-' . $field['name'] . '" class="field field_type-' . $field['type'] . ' field_key-' . $field['key'] . $required_class . '" data-field_name="' . $field['name'] . '" data-field_key="' . $field['key'] . '" data-field_type="' . $field['type'] . '">';

                    echo '<th>';
                    echo '<label for="' . $field['id'] . '">' . $field['label'] . $required_label . '</label>';
                    echo $field['instructions'];
                    echo '</th>';

                    echo '<td>';

                    $field['name'] = $this -> get_form_control().'[' . $field['name'] . ']';
                    do_action('acf/create_field', $field, $post_id);

                    echo '</td>';
                    echo '</tr>';

                } }
            ?>
        </tbody>
    </table>

</div>
