<?php

namespace DealerShip\Admin\Tables;

use DealerShip\DLS_Function;

defined('DEALERSHIP') or exit();

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class UserRolesTable extends \WP_List_Table{

    var $text_domain    = '';
    var $parent_slug    = '';
    var $menu_slug      = '';

    /**
     * @var string
     */
    var $no_items_message = '';


    /**
     * @var array
     */
    var $sortable_columns = array();


    /**
     * @var string
     */
    var $default_sorting_field = '';


    /**
     * @var array
     */
    var $actions = array();


    /**
     * @var array
     */
    var $bulk_actions = array();


    /**
     * @var array
     */
    var $columns = array();

    /**
     * UM_Roles_List_Table constructor.
     *
     * @param array $args
     */
    public function __construct( $args = array() ) {
        $this -> text_domain    = DLS_Function::get_my_text_domain();
        $args = wp_parse_args( $args, array(
            'singular' => __( 'item', 'dealership' ),
            'plural'   => __( 'items', 'dealership' ),
            'ajax'     => false,
        ) );

        $this -> menu_slug      = isset($args['menu_slug'])?$args['menu_slug']:$this -> menu_slug;
        $this -> parent_slug    = isset($args['parent_slug'])?$args['parent_slug']:$this -> parent_slug;

        $this->no_items_message = $args['plural'] . ' ' . __( 'not found.', 'dealership' );

        parent::__construct( $args );
    }


//    /**
//     * @param callable $name
//     * @param array $arguments
//     *
//     * @return mixed
//     */
//    public function __call( $name, $arguments ) {
//        return \call_user_func_array( array( $this, $name ), $arguments );
//    }

    /**
     *
     */
    public function prepare_items() {
        $columns               = $this->get_columns();
        $hidden                = array();
        $sortable              = $this->get_sortable_columns();
        $this->_column_headers = array( $columns, $hidden, $sortable );
    }


    /**
     * @param object $item
     * @param string $column_name
     *
     * @return string
     */
    function column_default( $item, $column_name ) {
        if( isset( $item[ $column_name ] ) ) {
            return $item[ $column_name ];
        } else {
            return '';
        }
    }

    /**
     *
     */
    public function no_items() {
        echo $this->no_items_message;
    }

    /**
     * @param array $args
     *
     * @return $this
     */
    public function set_sortable_columns( $args = array() ) {
        $return_args = array();
        foreach ( $args as $k => $val ) {
            if ( is_numeric( $k ) ) {
                $return_args[ $val ] = array( $val, $val === $this->default_sorting_field );
            } elseif ( is_string( $k ) ) {
                $return_args[ $k ] = array( $val, $k === $this->default_sorting_field );
            } else {
                continue;
            }
        }
        $this->sortable_columns = $return_args;
        return $this;
    }


    /**
     * @return array
     */
    public function get_sortable_columns() {
        return $this->sortable_columns;
    }

    /**
     * @param array $args
     *
     * @return $this
     */
    public function set_columns( $args = array() ) {
        if( count( $this->bulk_actions ) ) {
            $args = array_merge( array( 'cb' => '<input type="checkbox" />' ), $args );
        }
        $this->columns = $args;
        return $this;
    }

    /**
     * @return array
     */
    public function get_columns() {
        return $this->columns;
    }


    /**
     * @param array $args
     *
     * @return $this
     */
    public function set_bulk_actions( $args = array() ) {
        $this->bulk_actions = $args;
        return $this;
    }


    /**
     * @return array
     */
    public function get_bulk_actions() {
        return $this->bulk_actions;
    }

    /**
     * @param object $item
     *
     * @return string
     */
    public function column_cb( $item ) {
        return sprintf( '<input type="checkbox" name="item[]" value="%s" />', $item['key'] );
    }

    /**
     * @param $item
     *
     * @return string
     */
    public function column_title( $item ) {
        $actions = array();
        // for backward compatibility based on #906 pull-request (https://github.com/ultimatemember/ultimatemember/pull/906)
        // roles e.g. "subs" with both latin + not-UTB-8 symbols had invalid role ID
        $id = urlencode( $item['key'] );
//        if ( ! empty( $item['_dls_is_custom'] ) ) {
//            $id = preg_replace('/^dls_/', '', $id);
//        }

        $actions['edit'] = '<a href="' . add_query_arg(array('page' => $this -> menu_slug,
                'tab' => 'edit', 'id' => esc_attr( $id )),
                admin_url($this -> parent_slug)). '">' . __( 'Edit', 'dealership' ) . '</a>';

        if ( ! empty( $item['_dls_is_custom'] ) ) {
            $actions['delete'] = '<a href="' . add_query_arg(array('page' => $this -> menu_slug,
                    'action' => 'delete', 'id' => esc_attr( $id ),
                    '_wpnonce' => wp_create_nonce( 'dls_role_delete' . $item['key'] . get_current_user_id() )),
                    admin_url($this -> parent_slug)). '" onclick="return confirm( \'' . __( 'Are you sure you want to delete this role?', 'dealership' ) . '\' );">' . __( 'Delete', 'dealership' ) . '</a>';
        } else {
            $role_meta = get_option( "dls_role_{$item['key']}_meta" );

            if ( ! empty( $role_meta ) ) {
                $actions['reset'] = '<a href="admin.php?page='.$this -> menu_slug.'&action=reset&id=' . esc_attr( $id ) . '&_wpnonce=' . wp_create_nonce( 'dls_role_reset' . $item['key'] . get_current_user_id() ) . '" onclick="return confirm( \'' . __( 'Are you sure you want to reset UM role meta?', 'dealership' ) . '\' );">' . __( 'Reset DLS Role meta', 'dealership' ) . '</a>';
            }
        }

        return sprintf('%1$s %2$s', '<strong><a class="row-title" href="admin.php?page='.$this -> menu_slug.'&tab=edit&id=' . esc_attr( $id ) . '">' . stripslashes( $item['name'] ) . '</a></strong>', $this->row_actions( $actions ) );
    }


    /**
     * @param $item
     *
     * @return string
     */
    public function column_roleid( $item ) {
        return ! empty( $item['_dls_is_custom'] ) ? 'dls_' . $item['key'] : $item['key'];
    }

    /**
     * @param $item
     */
    public function column_core( $item ) {
        echo ! empty( $item['_dls_is_custom'] ) ? __( 'Yes', 'dealership' ) : __( 'No', 'dealership' );
    }

    /**
     * @param $item
     */
    public function column_admin_access( $item ) {
        echo ! empty( $item['_dls_can_access_wpadmin'] ) ? __( 'Yes', 'dealership' ) : __( 'No', 'dealership' );
    }


    /**
     * @param $item
     */
    public function column_priority( $item ) {
        echo ! empty( $item['_dls_priority'] ) ? $item['_dls_priority'] : '-';
    }

    /**
     * @param array $attr
     */
    public function dls_set_pagination_args( $attr = array() ) {
        $this->set_pagination_args( $attr );
    }
}