<?php

namespace DealerShip\Admin\MetaBoxes;

use DealerShip\DLS_Function;
use DealerShip\Interfaces\Metabox;
use DealerShip\Admin\Pages\UserRoles;

defined('DEALERSHIP') or exit();

class GeneralPermission extends Metabox {

    public function __construct()
    {
        parent::__construct();

        $this -> save_metabox();
    }

    public function save_metabox(){

        // verify nonce
        if( !isset($_POST[self::$metabox_prefix.'_nonce']))
        {
            return;
        }

        $metabox_args   = $this -> register();
//        if ( ! empty( $_POST[self::$metabox_prefix.'__userroles'] ) ) {
        $key    = self::$metabox_prefix.$metabox_args['name'];
        if ( ! empty( $_POST[$key] ) ) {

            $menu_slug      = self::$metabox_prefix.'_user_roles';
            $userRolePage   = UserRoles::instance();
            if($userRolePage && method_exists($userRolePage, 'get_property')){
                $menu_slug  = $userRolePage -> get_property('menu_slug');
            }

            $id       = '';
            $redirect = '';
            $error    = '';

            if ( 'add' === sanitize_key( $_GET['tab'] ) ) {
                if ( ! wp_verify_nonce( $_POST[self::$metabox_prefix.'_nonce'], self::$metabox_prefix.'-add-role' ) ) {
                    $error = __( 'Security Issue', 'dealership' ) . '<br />';
                }
            } else {
                if ( ! wp_verify_nonce( $_POST[self::$metabox_prefix.'_nonce'], self::$metabox_prefix.'-edit-role' ) ) {
                    $error = __( 'Security Issue', 'dealership' ) . '<br />';
                }
            }

            if ( empty( $error ) ) {



                $data       = $_POST[$key];
                $role_data  = isset($_POST[DEALERSHIP_PREFIX.'__userroles'])?$_POST[DEALERSHIP_PREFIX.'__userroles']:'';
                $is_custom  = isset($role_data['_dls_is_custom'])?filter_var($role_data['_dls_is_custom'], FILTER_VALIDATE_BOOLEAN):true;

                if ( 'add' === sanitize_key( $_GET['tab'] ) ) {

                    $role_data['name'] = trim( esc_html( strip_tags( $role_data['name'] ) ) );

                    if ( empty( $role_data['name'] ) ) {
                        $error .= __( 'Title is empty!', 'dealership') . '<br />';
                    }

                    if ( preg_match( "/^[\p{Latin}\d\-_ ]+$/i", $role_data['name'] ) ) {
                        // uses sanitize_title instead of sanitize_key for backward compatibility based on #906 pull-request (https://github.com/ultimatemember/ultimatemember/pull/906)
                        // roles e.g. "潜水艦subs" with both latin + not-UTB-8 symbols had invalid role ID
                        $id = sanitize_title( $role_data['name'] );
                    } else {
//                        $auto_increment = UM()->options()->get( 'custom_roles_increment' );
                        $auto_increment = ! empty( $auto_increment ) ? $auto_increment : 1;
                        $id             = 'custom_role_' . $auto_increment;
                    }

                    $redirect = add_query_arg( array( 'page' => $menu_slug,
                        'tab' => 'edit', 'id' => $id, 'msg' => 'a' ), admin_url( 'admin.php' ) );
                } elseif ( 'edit' === sanitize_key( $_GET['tab'] ) && ! empty( $_GET['id'] ) ) {
                    // uses sanitize_title instead of sanitize_key for backward compatibility based on #906 pull-request (https://github.com/ultimatemember/ultimatemember/pull/906)
                    // roles e.g. "潜水艦subs" with both latin + not-UTB-8 symbols had invalid role ID
                    $id = sanitize_title( $_GET['id'] );

                    $pre_role_meta = get_option( self::$metabox_prefix."_role_{$id}_meta", array() );
                    if ( isset( $pre_role_meta['name'] ) ) {
                        $role_data['name'] = $pre_role_meta['name'];
                    }

                    $redirect = add_query_arg( array( 'page' => $menu_slug,
                        'tab' => 'edit', 'id' => $id, 'msg'=> 'u' ), admin_url( 'admin.php' ) );
                }

                $all_roles = array_keys( get_editable_roles() );
                if ( 'add' === sanitize_key( $_GET['tab'] ) ) {
                    if ( in_array( self::$metabox_prefix.'_' . $id, $all_roles, true ) || in_array( $id, $all_roles, true ) ) {
                        $error .= __( 'Role already exists!', 'dealership' ) . '<br />';
                    }
                }

                if ( '' === $error ) {

                    if ( 'add' === sanitize_key( $_GET['tab'] ) ) {
                        $roles   = get_option( 'dls_roles', array() );
                        $roles[] = $id;

                        update_option( self::$metabox_prefix.'_roles', $roles );

//                        if ( isset( $auto_increment ) ) {
//                            $auto_increment++;
//                            UM()->options()->update( 'custom_roles_increment', $auto_increment );
//                        }
                    }

                    $data['wp_capabilities']   = array(
                        'read'  => true,
                        'read_private_pages'  => true,
                        'read_private_posts'  => true,
                        'upload_files'  => true,
//                        'edit_post'  => true,
//                        'edit_posts'  => true,
                        'edit_published_pages'  => true,
                        'edit_others_pages'  => true,
//                        'delete_posts'  => true,
                    );
                    $role_meta = array_merge($role_data, $data);
//                    $role_meta['name'] = $role_data['name'];
                    unset( $role_meta['id'] );

                    $result = \update_option( self::$metabox_prefix."_role_{$id}_meta", $role_meta );

//                    add_role(self::$metabox_prefix.'_'.$id, $role_data['name'], $data);
//                    add_role(self::$metabox_prefix.'_'.$id, $role_data['name'], array('_dls_can_add' => true));

//                    if($is_custom && !get_role(self::$metabox_prefix.'_'.$id)) {
//                        add_role(self::$metabox_prefix . '_' . $id, $role_data['name'], array(
////                            'read' => true,
////                            'delete_posts' => true,
//                            'edit_others_pages' => true,
//                            'upload_files' => true));
//                    }


//                    $my_role    = get_role(self::$metabox_prefix.'_'.$id);
//
//                    var_dump($my_role); die(__FILE__);
//                    $my_role -> add_cap('edit_posts');
//                    $my_role -> add_cap('delete_posts');
//                    $my_role -> add_cap('edit_published_pages');
////                    $my_role -> add_cap('delete_private_pages');
////                    $my_role -> add_cap('delete_published_pages');
////                    $my_role -> add_cap('delete_published_posts');
////                    $my_role -> add_cap('delete_published_posts');
//
//                    $my_role -> add_cap('upload_files');



                    /** To upload files on front-end need permissions:
                     * @   edit_others_pages, upload_files
                     * */


                    if($result){
                        DLS_Function::js_redirect($redirect);
                    }
                }
            }
        }
    }


    public function register(){
        return array(
            'title'         => __('General Permissions', 'dealership'),
            'name'          => '__'.$this -> get_name(),/* */
//            'context'       => 'side', // normal, advanced, side
            'context'       => 'normal', // normal, advanced, side
            'priority'      => 'default', // high, core, default, low - Priorities of placement
//            'screen'        => 'dls_user_roles', /*The screen or screens on which to show the box (such as a post type, 'link', or 'comment')*/
            'screen'        => self::$metabox_prefix.'_user_role_meta', /*The screen or screens on which to show the box (such as a post type, 'link', or 'comment')*/
        );
    }

    public function register_fields(){
        return array(
            array(
                'key'   => 'field_62bd6df3befb0',
                'name'  => '_dls_can_add',
                'type'  => 'true_false',
                'label' => __('Can add', 'dealership'),
                'default' => '1',
            ),
            array(
                'key'   => 'field_62bd762b82b06',
                'name'  => '_dls_can_edit_private',
                'type'  => 'true_false',
                'label' => __('Can edit', 'dealership'),
                'default' => 1,
            ),
            array(
                'key'   => 'field_62bd767aa0b16',
                'name'  => '_dls_can_delete_private',
                'type'  => 'true_false',
                'label' => __('Can delete', 'dealership'),
                'layout'	=>	'horizontal',
                'choices'	=>	array(
                    1	=>	__("Yes", 'dealership'),
                    0	=>	__("No", 'dealership'),
                ),
                'default' => 1,
            ),
            array(
                'key'   => 'field_6389662b061dd',
                'name'  => '_dls_can_list_other_image',
                'type'  => 'true_false',
                'label' => __('Can List Other Image', 'dealership'),
                'layout'	=>	'horizontal',
                'choices'	=>	array(
                    1	=>	__("Yes", 'dealership'),
                    0	=>	__("No", 'dealership'),
                ),
                'default'   => 0,
            ),
            array(
                'key'   => 'field_6389662b061st',
                'name'  => '_dls_product_status',
                'type'  => 'select',
                'label' => __('Product Status', 'dealership'),
                'layout'	=>	'horizontal',
                'choices'	=>	array(
                    'publish'	=>	__("Publish", 'dealership'),
                    'draft'	=>	__("Draft", 'dealership'),
                    'pending'	=>	__("Pending", 'dealership'),
                ),
                'default'   => 'pending',
            ),
//            array(
//                'key'   => 'field_6389662b061dd',
//                'name'  => '_dls_can_view_image',
//                'type'  => 'true_false',
//                'label' => __('Can View Image', 'dealership'),
//                'layout'	=>	'horizontal',
//                'choices'	=>	array(
//                    1	=>	__("Yes", 'dealership'),
//                    0	=>	__("No", 'dealership'),
//                ),
//                'default'   => 0,
//            ),
//            array(
//                'key'   => 'field_638968e7c2e9e',
//                'name'  => '_dls_can_read_private_image',
//                'type'  => 'true_false',
//                'label' => __('Can Read Own Image', 'dealership'),
//                'layout'	=>	'horizontal',
//                'choices'	=>	array(
//                    1	=>	__("Yes", 'dealership'),
//                    0	=>	__("No", 'dealership'),
//                ),
//                'default'   => 1
//            ),
        );
    }
}