<?php

namespace DealerShip\Admin;

use DealerShip\Helpers\UserRoleHelper;
use DealerShip\Interfaces\AdminTemplate;

defined('DEALERSHIP') or exit();

class AdminWPUser extends AdminTemplate{

    protected $default_layout       = 'base';

    public function __construct()
    {
        parent::__construct();

        $this -> default_layout_type    .= '/'.$this -> get_name();
    }

    public function hooks(){

        add_action( 'show_user_profile', array( $this, 'render' ), 10 );
        add_action( 'user_new_form', array( $this, 'render' ), 10 );
        add_action( 'edit_user_profile', array( $this, 'render' ), 10 );

//        add_action('personal_options_update', array($this, 'profile_update'));
//        add_action('edit_user_profile_update', array($this, 'profile_update'));
//        add_action('user_register', array($this, 'profile_update'));

//        add_action( 'profile_update', array( &$this, 'profile_update' ) ); // user_id and old_user_data
        add_action( 'profile_update', array( &$this, 'profile_update' ), 10, 2 ); // user_id and old_user_data
        add_action('restrict_manage_users', array(&$this, 'restrict_manage_users'));

        add_action( 'admin_init', array( &$this, 'bulk_users_edit' ), 9 );

        add_filter( 'manage_users_columns', array( &$this, 'manage_users_columns' ), 11 );
        add_filter( 'manage_users_custom_column', array( &$this, 'manage_users_custom_column' ), 10, 3 );
    }

    public function restrict_manage_users(){
        ?>
        <div style="float:right;margin:0 4px">
            <select name="dls_bulk_action[]">
                <option value=""><?php echo __('Dealer Action', 'dealership');?></option>
                <option value="pending"><?php echo __('Pending', 'dealership');?></option>
                <option value="approved"><?php echo __('Approve', 'dealership');?></option>
            </select>
            <input name="dls_bulkedit" id="dls_bulkedit" class="button" value="<?php
            echo __('Apply', 'dealership');?>" type="submit">
        </div>
    <?php
    }

    public function bulk_users_edit(){

        // bulk edit users
        if ( ! empty( $_REQUEST['users'] ) && ! empty( $_REQUEST['dls_bulkedit'] )
            && ! empty( $_REQUEST['dls_bulk_action'] ) ) {

            check_admin_referer( 'bulk-users' );

            $users       = array_map( 'absint', (array) $_REQUEST['users'] );
            $bulk_action = current( array_filter( $_REQUEST['dls_bulk_action'] ) );

            foreach ( $users as $user_id ) {

                do_action( 'dealership/admin_user_action_hook', $bulk_action );

                update_user_meta($user_id, 'dls_account_status', $bulk_action);
            }

            $uri = $this->set_redirect_uri( admin_url( 'users.php' ) );
            $uri = add_query_arg( 'update', 'users_updated', $uri );

            wp_redirect( $uri );
            exit;
        }
    }

    public function set_redirect_uri( $uri ) {

        if ( ! empty( $_REQUEST['s'] ) ) {
            $uri = add_query_arg( 's', sanitize_text_field( $_REQUEST['s'] ), $uri );
        }

        if ( ! empty( $_REQUEST['dls_status'] ) ) {
            $uri = add_query_arg( 'dls_status', sanitize_key( $_REQUEST['dls_status'] ), $uri );
        }

        return $uri;

    }

    public function manage_users_columns( $columns ) {
        $columns['dls_account_status'] = __( 'Dealer Status', 'dealership' );
        return $columns;
    }

    public function manage_users_custom_column( $val, $column_name, $user_id ) {
        if ( $column_name == 'dls_account_status' ) {
            $status = get_user_meta($user_id, $column_name, true);
            switch($status){
                default:
                case 'approved':
                    return __('Approved', 'dealership');
                    break;
                case 'pending':
                    return __('Pending', 'dealership');
                    break;
            }
            return $val;
        }
        return $val;
    }

    public function get_form_control(){
        return 'dls_'.$this -> get_name();
    }

    public function profile_update( $user_id, $old_data ) {
        if (!current_user_can('edit_user', $user_id)) {
            return;
        }

        $form_control   = $this -> get_form_control();
        $my_data    = isset($_POST[$form_control])?$_POST[$form_control]:array();
        $wp_role    = isset($_POST['role'])?$_POST['role']:array();
        $new_role   = isset($my_data['_dls_role'])?$my_data['_dls_role']:'';

        $new_role   = !empty($new_role)?$new_role:$wp_role;

        if(!empty($my_data) && !empty($new_role) && isset($my_data['_dls_role'])){
            unset($my_data['_dls_role']);
        }
        // Store other dealership data
        if(!empty($my_data)){
            foreach ($my_data as $meta_key => $meta_value){
                update_user_meta($user_id, $meta_key, $meta_value);
            }
        }

        $user   = get_userdata($user_id);

        // Get users old DLS role
        $role = UserRoleHelper::get_user_role($user_id);

        if (!empty($new_role) &&($new_role === $role || ( ! UserRoleHelper::is_role_custom( $new_role ) && user_can( $user, $new_role ) ) )) {
            return;
        } else {
            // Remove the old DLS role
            if (  ! empty( $role ) && UserRoleHelper::is_role_custom( $role ) ) {
                $user->remove_role( $role );
            }

            // Add the new role
            if ( ! empty( $new_role ) ) {
                $user->add_role( $new_role );
            }
        }
    }

    public function register_fields(){
        $choices    = array(
                ''  => esc_html__('— No role —', 'dealership')
            )+ ((array) UserRoleHelper::get_role_choices(array('choice_has_prefix' => true)));

        $user_id    = isset($_REQUEST['user_id'])?$_REQUEST['user_id']:0;
        $role       = UserRoleHelper::get_user_role($user_id);
        $role       = !empty($role)?$role:'';

        return array(
            array(
                'key'   => 'field_6387296aceb00',
                'name'  => '_dls_role',
                'type'  => 'select',
                'label' => __('Advanced Product Role', 'dealership'),
                'layout'	=>	'horizontal',
                'choices'	=>	$choices,
                'value'     => $role
            ),
            array(
                'key'   => 'field_6387296aceb01',
                'name'  => '_dls_map_location',
                'type'  => 'text',
                'label' => __('Map Location', 'dealership'),
                'layout'	=>	'horizontal',
            ),
        );
    }

    public function render()
    {
//        \do_action('dls_wp_user_role_add_meta_boxes', 'dls_wp_user_role_meta');
        return $this -> render_template(false);
    }
}