<?php

namespace DealerShip\Admin;

use DealerShip\Interfaces\Base;

defined('DEALERSHIP') or exit();

class AdminPostTypes extends Base {
    protected $pages    = array();
    public function __construct()
    {
        add_action( 'init', [ $this, 'register_post_type' ], 11 );
    }

    public function register_post_type(){
        $path   = DEALERSHIP_POSTTYPES_PATH;
        if(!$path || ($path && !is_dir($path))){
            return false;
        }

        $files  = glob($path.'/*.php');

        if(count($files)){
            foreach ($files as $file){
                $info = pathinfo($file);
                $file_name  = $info['filename'];

                if(!is_file($file)){
                    $file   .= '/'.$file_name.'.php';
                }

//                $name_space = 'DealerShip\Admin\Pages';
                $class_name = 'DealerShip\Admin\PostTypes\\'.ucfirst(str_replace('-', '_', $file_name));

//                if(file_exists($file) && !class_exists($class_name)){
//                    require_once $file;
//                }

                if(class_exists($class_name)){
//                    $page_obj  = new $class_name($this);
                    $page_obj  = \call_user_func(array($class_name, 'instance'));
                    $this -> pages[$file_name] = $page_obj;
                }
            }
        }
    }

//    /**
//     * Wrapper for the hook to render our custom settings pages.
//     *
//     * @since 1.0.0
//     */
//    public function admin_page() {
//        do_action( 'wpforms_admin_page' );
//    }
}