<?php

namespace DealerShip\Admin;

use DealerShip\Interfaces\Base;

defined('DEALERSHIP') or exit();

class AdminMenus extends Base {
    protected $pages    = array();
    public function __construct()
    {
        parent::__construct();
//        add_action( 'admin_menu', [ $this, 'register_menus' ], 11 );
        add_action( 'plugins_loaded', [ $this, 'register_menus' ], 11 );
    }

    public function register_menus(){
        $path   = DEALERSHIP_PAGES_PATH;
        if(!$path || ($path && !is_dir($path))){
            return false;
        }

        $files  = glob($path.'/*.php');

        if(count($files)){
            foreach ($files as $file){
                $info = pathinfo($file);
                $file_name  = $info['filename'];

                if(!is_file($file)){
                    $file   .= '/'.$file_name.'.php';
                }

                $class_name = 'DealerShip\Admin\Pages\\'.ucfirst(str_replace('-', '_', $file_name));

                if(class_exists($class_name)){
                    $page_obj  = \call_user_func(array($class_name, 'instance'));
                    $this -> pages[$file_name] = $page_obj;
                }
            }
        }
    }
}