<?php

namespace Advanced_Product;

defined('ADVANCED_PRODUCT') or exit();

class Meta_box extends Base {

    protected $prefix   = 'ap_meta_box_';
    /**
     * directory string.
     * Only use to the class is different with file name
     *
     * @var		string
     */
    protected $directory= '';

    public function hooks()
    {
        parent::hooks(); // TODO: Change the autogenerated stub

        add_action( 'add_meta_boxes', array( $this, 'register_meta_box' ) );
        add_action( 'save_post', array( $this, 'save_meta_box' ), 10, 2 );
    }

    public function get_meta_box_name(){
        $store_id   = $this -> _get_store_id(__METHOD__);

        if(isset($this -> cache[$store_id])){
            return $this -> cache[$store_id];
        }

        $class_name = get_class($this);
        $class_name = preg_replace('#^'.addslashes(__CLASS__).'\\\\#i', '', $class_name);
        $class_name = preg_replace('/^Advanced_Product\\\\Meta_Box\\\\/i', '', $class_name);
        $class_name = $this -> prefix.strtolower($class_name);

        $this -> cache[$store_id]   = $class_name;

        return $class_name;
    }

    public function register_meta_box(){
        $metabox  = $this->get_meta_box_name();

        // Register post type to wordpress
        if(method_exists($this, 'register')) {
            $args   = $this -> register();

            if(!$args || !count($args)){
                return;
            }

            $title      = isset($args['title'])?$args['title']:$this -> get_name();
            $screen     = isset($args['screen'])?$args['screen']:'';
            $context    = isset($args['context'])?$args['context']:(isset($args['position'])?$args['position']:'');

            \add_meta_box($metabox, $title, array($this, 'render'), $screen,
                $context, $args['priority']);
            do_action('advanced-product/metabox/'.$metabox.'/registered', $metabox, $this);

        }
    }

    /*
     * * Store meta box params
     * @param int/string $post_id
     * @params object $post
     * */
    public function save_meta_box( $post_id, $post ) {
        // Check if user has permissions to save data.
        if ( ! $this -> can_save($post_id, $post) ) {
            return;
        }

        if(!method_exists($this, 'register')){
            return;
        }

        $metabox    = $this -> register();
        $mt_key     = isset($metabox['name'])?$metabox['name']:$this -> prefix.$this -> get_meta_box_name();
        if ( isset( $_POST[$mt_key] ) ) {
            $options    = $_POST[$mt_key];
            if(isset($metabox['store_each']) && $metabox['store_each']){
                foreach ($options as $key => $option){
                    update_post_meta($post_id, $key, $option);
                }
            }else {
                update_post_meta($post_id, $mt_key, $options);
            }
        }
    }

    /*
         * Check meta box permission to store
         * @param int/string $post_id
         * @params object $post
         * */
    public function can_save($post_id, $post){
        // Check if user has permissions to save data.
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return false;
        }

        // Check if not an autosave.
        if ( wp_is_post_autosave( $post_id ) ) {
            return false;
        }

        // Check if not a revision.
        if ( wp_is_post_revision( $post_id ) ) {
            return false;
        }

        return true;
    }

    public function render(){
        $folder_name    = !empty($this -> directory)?$this -> directory:$this -> get_name();

        $file   = ADVANCED_PRODUCT_CORE_PATH.'/meta-boxes/'.$folder_name.'/tpl/base.php';

        if(file_exists($file)){
            require $file;
        }
    }
}