<?php

namespace Advanced_Product\Taxonomy;

use Advanced_Product\Helper\FieldHelper;
use Advanced_Product\Taxonomy;
use um\core\Validation;

defined('ADVANCED_PRODUCT') or exit();

class Group_Field extends Taxonomy {

    protected $cache    = array();

    public function hooks()
    {
        parent::hooks(); // TODO: Change the autogenerated stub

        add_action( 'admin_menu', array( $this, 'admin_menu' ) );
        add_action( 'parent_file', array($this,'menu_highlight' ));
        add_action( 'saved_'.$this ->get_taxonomy_name(), array($this,'saved_taxonomy'), 10, 2 );
        add_action( 'wp_ajax_ap_taxonomy_ap_group_field_sortable', array($this, 'saveAjaxOrder'));
        add_action( 'wp_ajax_nopriv_ap_taxonomy_ap_group_field_sortable', array($this, 'saveAjaxOrder'));
        add_action('advanced-product/taxonomy/'.$this -> get_taxonomy_name().'/registered', array($this, 'registered_taxonomy'));

        add_filter('get_terms_orderby', array($this, 'get_terms_orderby'), 100, 2);
        add_filter('posts_orderby', array($this, 'taxonomy_orderby'), 100, 2);
        add_filter( 'manage_edit-'.$this -> get_taxonomy_name().'_sortable_columns', array($this,'sortable_columns') );

    }

    public function register(){

        $singular  = __( 'Custom Field Group', 'advanced-product' );
        $plural    = __( 'Custom Field Groups', 'advanced-product' );

        return array(
            'object_type'   => 'ap_custom_field',
            'args'          => array(
                'label' 					=> $plural,
                'labels' => array(
                    'name' 					=> $singular,
                    'singular_name' 		=> $singular,
                    'menu_name'				=> $plural,
                    'search_items' 			=> sprintf( __( 'Search %s', 'advanced-product' ), $plural ),
                    'all_items' 			=> sprintf( __( 'All %s', 'advanced-product' ), $plural ),
                    'parent_item' 			=> sprintf( __( 'Parent %s', 'advanced-product' ), $singular ),
                    'parent_item_colon'		=> sprintf( __( 'Parent %s:', 'advanced-product' ), $singular ),
                    'edit_item' 			=> sprintf( __( 'Edit %s', 'advanced-product' ), $singular ),
                    'update_item' 			=> sprintf( __( 'Update %s', 'advanced-product' ), $singular ),
                    'add_new_item' 			=> sprintf( __( 'Add New %s', 'advanced-product' ), $singular ),
                    'new_item_name' 		=> sprintf( __( 'New %s Name', 'advanced-product' ),  $singular ),
                    'not_found' 		    => sprintf( __( 'No %s found.', 'advanced-product' ),  $plural ),
                ),
                'hierarchical'              => true,
                'show_admin_column'         => true,
                'show_in_nav_menus'         => false,
                'query_var' => true,
            )
        );
    }

    public function registered_taxonomy($taxonomy){
        if($this -> get_taxonomy_name() == $taxonomy){
            FieldHelper::add_term_order_field();
        }
    }

    public function admin_menu(){
        add_submenu_page('edit.php?post_type=ap_product', 'Custom Field Groups',
            'Custom Field Groups', 'manage_options',
            'edit-tags.php?taxonomy='.$this -> get_taxonomy_name().'&post_type=ap_custom_field'/*,'bsp_students_add'*/);
    }

    /* Set menu highlight because wp not active */
    public function menu_highlight( $parent_file ) {
        global $submenu_file, $post_type, $taxonomy;

        if ( $taxonomy == $this -> get_taxonomy_name() && $post_type == 'ap_custom_field' ) {
            $parent_file = 'edit.php?post_type=ap_product';
            $submenu_file = 'edit-tags.php?taxonomy='.$this -> get_taxonomy_name().'&post_type=ap_custom_field';    // the submenu slug
        }

        return $parent_file;
    }

    public function __get_core_fields(){
        $fields = array(
            array(
                'key'       => 'field_'.md5($this -> get_taxonomy_name().'__branch'),
                'label'     => __('Branches Assignment', 'advanced-product'),
                'name'      => 'branch_assigned',
                'type'      => 'taxonomy',
                'taxonomy'  => 'ap_branch',
                'load_save_terms'  => false,
                'group' => $this -> __get_core_field_group_id()
            )
        );

        return apply_filters('advanced-product/'.$this -> get_taxonomy_name().'/fields/create', $fields);
    }

    public function manage_edit_columns($columns){
        $pos            = array_search('name', array_keys($columns)) + 1;
        $new_columns    = array('branch_assigned' => __('Branch Assigned', 'advanced-product'));

        $order_column   = array();

        if($this -> term_order_exists()) {
            $order_column               = array_slice($columns, 0, $pos-1);
            $order_column['term_order'] = __('Order','advanced-product');
        }

        return array_merge(
            $order_column,
            array_slice($columns, 0, $pos),
            $new_columns,
            array_slice($columns, $pos)
        );

    }

    public function manage_custom_column($content, $column, $term_id ){
        if($column == 'term_order') {
            $order_by   = isset($_REQUEST['orderby'])?$_REQUEST['orderby']:'';
            $inactive   = $order_by != 'term_order'?' ap-inactive':'';

            echo '<span class="dashicons dashicons-menu-alt2 ap-handle'.$inactive.'"></span>';
        }
        if($column == 'branch_assigned'){
            $fval   = \get_field( $column, 'term_'.$term_id );

            if(!empty($fval) && count($fval)){
                foreach($fval as $i => $slug){
                    $term   = get_term_by('slug', $slug, 'ap_branch');
                    if(!is_wp_error($term) && !empty($term)){
                        $content    .= '<a href="term.php?taxonomy=ap_branch&post_type=ap_product&tag_ID='
                            .$term -> term_id.'">'.$term -> name.'</a>';
                        if($i < count($fval) - 1){
                            $content    .= ', ';
                        }
                    }
                }
            }
        }
        return $content;
    }

    public function sortable_columns( $columns ) {
        if($this -> term_order_exists()) {
            $columns['term_order'] = 'term_order';
        }
        return $columns;
    }

    public function saved_taxonomy($term_id, $tt_id ){

        if(!$this -> my_taxonomy_exists()){
            return;
        }

        $term = get_term( $term_id );
        $tax_slug = $term->slug;

        clean_taxonomy_cache($this -> get_taxonomy_name());

        $branch_assigned    = (array) \get_field('branch_assigned', 'term_'.$term_id);

        $branch_taxs    = \get_terms(array(
            'taxonomy'      => 'ap_branch',
            'hide_empty'    => false,
        ));

        if(!is_wp_error($branch_taxs) && !empty($branch_taxs)){
            $field_key  = 'field_'.md5('ap_branch__group_field');
            foreach($branch_taxs as $branch){

                $group_assigned = \get_field('group_field_assigned', 'term_' . $branch->term_id);
                $group_assigned = !empty($group_assigned)?$group_assigned:array();

                if(is_array($branch_assigned) && in_array($branch -> slug, $branch_assigned)){
                    if(!$group_assigned || (!empty($group_assigned) && !in_array($tax_slug, $group_assigned))){
                        $group_assigned[]   = $tax_slug;
                        if(!empty($group_assigned)){
                            update_field($field_key, array_values($group_assigned), 'term_' .$branch -> term_id);
                        }
                    }
                }else{
                    if(!empty($group_assigned)){
                        if(in_array($tax_slug, $group_assigned)) {
                            $group_assigned = array_diff($group_assigned, array($tax_slug));
                            update_field($field_key, array_values($group_assigned), 'term_' .$branch -> term_id);
                        }
                    }
                }
            }
        }
    }

    public function saveAjaxOrder(){

        set_time_limit(600);

        global $wpdb, $userdata;

        $post_type  =   filter_var ( $_POST['post_type'], FILTER_SANITIZE_STRING);
        $paged      =   filter_var ( $_POST['paged'], FILTER_SANITIZE_NUMBER_INT);
        $nonce      =   $_POST['archive_sort_nonce'];

        //verify the nonce
        if (! wp_verify_nonce( $nonce, 'ap_archive_sort_nonce_' . $userdata->ID ) )
            die();

        parse_str($_POST['order'], $data);

        if (!is_array($data)    ||  count($data)    <   1)
            die();

        //retrieve a list of all objects
        $mysql_query    =   $wpdb->prepare("SELECT t.term_id FROM ".  $wpdb->terms ." AS t
                                                    INNER JOIN {$wpdb -> term_taxonomy} AS tt ON tt.term_id = t.term_id
                                                            WHERE tt.taxonomy = '%s'
                                                                AND t.term_id IN(".implode(',', $data['tag']).")
                                                            ORDER BY t.term_order", $this -> get_taxonomy_name());
        $results        =   $wpdb->get_results($mysql_query);

        if (!is_array($results)    ||  count($results)    <   1)
            die();

        //create the list of ID's
        $objects_ids    =   array();
        foreach($results    as  $result)
        {
            $objects_ids[]  =   (int)$result->term_id;
        }

        global $userdata;
        $objects_per_page   =   get_user_meta($userdata->ID ,'edit_' .  $post_type  .'_per_page', TRUE);
        if(empty($objects_per_page))
            $objects_per_page   =   20;

        $edit_start_at      =   $paged  *   $objects_per_page   -   $objects_per_page;
        $index              =   0;
        for($i  =   $edit_start_at; $i  <   ($edit_start_at +   $objects_per_page); $i++)
        {
            if(!isset($objects_ids[$i]))
                break;

            $objects_ids[$i]    =   (int)$data['tag'][$index];
            $index++;
        }

        //update the menu_order within database
        foreach( $objects_ids as $term_order   =>  $id )
        {
            $data = array(
                'term_order' => $term_order
            );

            //Deprecated, rely on pto/save-ajax-order
            $data = apply_filters('advanced-product/taxonomy-order_save-ajax-order', $data, $term_order, $id);

            $data = apply_filters('advanced-product/save-ajax-order', $data, $term_order, $id);

            $updated    = $wpdb->update( $wpdb->terms, $data, array('term_id' => $id) );

            clean_post_cache( $id );
        }

        //trigger action completed
        do_action('advanced-product/taxonomy/order_update_complete');
    }

    public function taxonomy_orderby($orderBy, $query)
    {
        global $wpdb;

        // ignore other post type
        if($this -> get_current_screen_taxonomy() != $this -> get_taxonomy_name()){
            return $orderBy;
        }

        //check for orderby GET paramether in which case return default data
        if (isset($_GET['orderby']) && $_GET['orderby'] !=  'term_order')
            return $orderBy;

        //check to ignore
        /**
         * Deprecated filter
         * do not rely on this anymore
         */
        if(apply_filters('advanced-product/taxonomy_orderby', $orderBy, $query) === FALSE)
            return $orderBy;

        $ignore =   apply_filters('advanced-product/taxonomy_orderby/ignore', FALSE, $orderBy, $query);

        if($ignore  === TRUE)
            return $orderBy;

        if (is_admin())
        {
            global $post;

            if($query->is_main_query()){
                $order  =   isset($query->query_vars['order'])  ?   $query->query_vars['order'] : '';

                $order  =   apply_filters('advanced-product/taxonomy_orderby', $order, $query);
                $orderBy = "{$wpdb->terms}.term_order {$order}";
            }
        }

        return($orderBy);
    }

    public function get_terms_orderby($orderby, $args)
    {
        if($this -> term_order_exists()) {
            if (apply_filters('advanced-product/get_terms_orderby/ignore', FALSE, $orderby, $args))
                return $orderby;

            if (isset($args['orderby']) && $args['orderby'] == "term_order" && $orderby != "term_order")
                $orderby    = "t.term_order";
        }

        return $orderby;
    }

    protected function term_order_exists(){
        global $wpdb;

        $store_id   = md5(__METHOD__);

        if(isset($this -> cache[$store_id])){
            return $this -> cache[$store_id];
        }

        $query = "SHOW COLUMNS FROM $wpdb->terms 
                        LIKE 'term_order'";
        $result = $wpdb->query($query);

        if($result){
            $this -> cache[$store_id]   = $result;
        }

        return $result;
    }
}