<?php

namespace Advanced_Product\Taxonomy;

use Advanced_Product\Helper\FieldHelper;
use Advanced_Product\Taxonomy;

defined('ADVANCED_PRODUCT') or exit();

class Category extends Taxonomy {

    public function hooks()
    {
        parent::hooks(); // TODO: Change the autogenerated stub

        add_action( 'admin_menu', array( $this, 'remove_taxonomy_metaboxes' ) );

//        add_action( 'init', array( $this, 'register_fields' ) );
    }


    public function register(){

        $singular  = __( 'Category', 'advanced-product' );
        $plural    = __( 'Categories', 'advanced-product' );

        return array(
            'object_type'   => 'ap_product',
            'args'          => array(
                'label' 					=> $plural,
                'labels' => array(
                    'name' 					=> $singular,
                    'singular_name' 		=> $singular,
                    'menu_name'				=> $plural,
                    'search_items' 			=> sprintf( __( 'Search %s', 'advanced-product' ), $plural ),
                    'all_items' 			=> sprintf( __( 'All %s', 'advanced-product' ), $plural ),
                    'parent_item' 			=> sprintf( __( 'Parent %s', 'advanced-product' ), $singular ),
                    'parent_item_colon'		=> sprintf( __( 'Parent %s:', 'advanced-product' ), $singular ),
                    'edit_item' 			=> sprintf( __( 'Edit %s', 'advanced-product' ), $singular ),
                    'update_item' 			=> sprintf( __( 'Update %s', 'advanced-product' ), $singular ),
                    'add_new_item' 			=> sprintf( __( 'Add New %s', 'advanced-product' ), $singular ),
                    'new_item_name' 		=> sprintf( __( 'New %s Name', 'advanced-product' ),  $singular ),
                    'not_found' 		    => sprintf( __( 'No %s found.', 'advanced-product' ),  $plural ),
                ),
                'hierarchical'              => true,
                'show_admin_column'         => true,
//                'query_var'                 => false,
//                'rewrite'                   => array( 'slug' => 'category' ),
            )
        );

    }

    public function __get_core_fields(){
        $fields = parent::__get_core_fields();

        $fields[]   = array(
            'key' => 'field_529239ef5b2d9',
            'label' => esc_html__('Associated Branch', 'advanced-product'),
            'name' => 'ap_branch',
            'type' => 'taxonomy',
            'taxonomy' => 'ap_branch',
            'field_type' => 'multi_select',
            'allow_null' => 0,
            'load_save_terms' => 0,
            'return_format' => 'array',
//            'return_format' => 'slug',
            'multiple' => 1,
            'instructions' => __('Press and hold the CTRL key and click items in the list to select multiple items. ', 'advanced-product'),
            'default_value' => ''
        );

        return $fields;
    }

    public function manage_edit_columns($columns){
        $columns    = parent::manage_edit_columns($columns);

        $new_columns            = array();
        $new_columns['cb']      = $columns['cb'];
        if(isset($columns['thumb'])) {
            $new_columns['thumb'] = $columns['thumb'];
        }
        $new_columns['name']    = $columns['name'];

        $new_columns['ap_branch']   = __('Branch', 'advanced-product');

        return array_merge($new_columns, $columns);
    }

    public function manage_custom_column($content, $column, $term_id ){
        $content = parent::manage_custom_column($content, $column, $term_id);

        if($column == 'ap_branch'){
            $branches = \get_field( 'ap_branch', 'term_'.$term_id );
            if(!empty($branches) && count($branches)){
                foreach($branches as $i => $branch){
                    if(is_numeric($branch)) {
                        $term   = get_term_by('term_id', $branch, 'ap_branch');
                    }else {
                        $term = get_term_by('slug', $branch, 'ap_branch');
                    }
                    if(!empty($term) && !is_wp_error($term)){
                        $content    .= '<a href="'.get_edit_term_link($term -> term_id, $term -> taxonomy).'">'.$term -> name.'</a>';
                        if($i < count($branches) - 1) {
                            $content .= '<span>, </span>';
                        }
                    }
                }
            }
        }

        return $content;
    }

    /**
     * Removes the default taxonomy metaboxes from the edit screen.
     * We use the advanced custom fields instead and sync the data.
     */
    public function remove_taxonomy_metaboxes(){
        /* Remove meta box is tag */
        \remove_meta_box( 'tagsdiv-'.$this -> get_taxonomy_name(), 'ap_product', 'normal' );
        /* Remove meta box is category */
        \remove_meta_box( $this -> get_taxonomy_name().'div', 'ap_product', 'normal' );
    }
}