<?php

namespace Advanced_Product\Taxonomy;

use Advanced_Product\Helper\AP_Custom_Taxonomy_Helper;
use Advanced_Product\Taxonomy;

defined('ADVANCED_PRODUCT') or exit();

class Branch extends Taxonomy {

    protected $old_slug = '';

    public function hooks()
    {
        parent::hooks(); // TODO: Change the autogenerated stub

        add_action( 'admin_menu', array( $this, 'remove_taxonomy_metaboxes' ) );
        add_action( 'saved_'.$this ->get_taxonomy_name(), array($this,'saved_taxonomy'), 11, 3 );
    }

    public function register(){

        $singular  = __( 'Branch', 'advanced-product' );
        $plural    = __( 'Branches', 'advanced-product' );

        return array(
            'object_type'   => 'ap_product',
            'args'          => array(
                'label' 					=> $plural,
                'labels' => array(
                    'name' 					=> $singular,
                    'singular_name' 		=> $singular,
                    'menu_name'				=> $plural,
                    'search_items' 			=> sprintf( __( 'Search %s', 'advanced-product' ), $plural ),
                    'all_items' 			=> sprintf( __( 'All %s', 'advanced-product' ), $plural ),
                    'parent_item' 			=> sprintf( __( 'Parent %s', 'advanced-product' ), $singular ),
                    'parent_item_colon'		=> sprintf( __( 'Parent %s:', 'advanced-product' ), $singular ),
                    'edit_item' 			=> sprintf( __( 'Edit %s', 'advanced-product' ), $singular ),
                    'update_item' 			=> sprintf( __( 'Update %s', 'advanced-product' ), $singular ),
                    'add_new_item' 			=> sprintf( __( 'Add New %s', 'advanced-product' ), $singular ),
                    'new_item_name' 		=> sprintf( __( 'New %s Name', 'advanced-product' ),  $singular ),
                    'not_found' 		    => sprintf( __( 'No %s found.', 'advanced-product' ),  $plural ),
                ),
                'hierarchical'               => true,
                'show_admin_column'          => true,
                'exclude_from_search'        => true,
//                'query_var'                 => false,
            )
        );
    }

    public function __get_core_fields(){
        $fields = parent::__get_core_fields();

        $fields[]   = array(
            'key'       => 'field_'.md5($this -> get_taxonomy_name().'__group_field'),
            'label'     => __('Group Fields Assignment', 'advanced-product'),
            'name'      => 'group_field_assigned',
            'type'      => 'taxonomy',
            'taxonomy'  => 'ap_group_field',
            'load_save_terms'  => false,
            'group'     => $this -> __get_core_field_group_id()
        );

        return apply_filters('advanced-product/'.$this -> get_taxonomy_name().'/fields/create', $fields);
    }

    public function saved_taxonomy($term_id, $tt_id, $update ){

        if(!$this -> my_taxonomy_exists()){
            return;
        }

        $term       = get_term( $term_id );
        $tax_slug   = $term->slug;

        clean_taxonomy_cache($this -> get_taxonomy_name());

        $group_field_assigned    = (array) \get_field('group_field_assigned', 'term_'.$term_id);

        $group_field_taxs    = get_terms(array(
            'taxonomy'      => 'ap_group_field',
            'hide_empty'    => false,
        ));

        if(!is_wp_error($group_field_taxs) && !empty($group_field_taxs)){
            $field_key  = 'field_'.md5('ap_group_field__branch');
            foreach($group_field_taxs as $group_field){
                $branch_assigned    = \get_field('branch_assigned', 'term_' . $group_field->term_id);
                $branch_assigned    = !empty($branch_assigned)?$branch_assigned:array();

                // Group field assigned to branch
                if(in_array($group_field -> slug, $group_field_assigned)){
                    if(!$branch_assigned || (!empty($branch_assigned) && !in_array($tax_slug, $branch_assigned))){
                        $branch_assigned[]   = $tax_slug;
                        if(!empty($branch_assigned)){
                            update_field($field_key, array_values($branch_assigned), 'term_'.$group_field -> term_id);
                        }
                    }
                }else{
                    // Remove current branch if it exists in group field not assigned
                    if(!empty($branch_assigned)){
                        if(in_array($tax_slug, $branch_assigned)) {
                            $branch_assigned = array_diff($branch_assigned, array($tax_slug));
                            update_field($field_key, array_values($branch_assigned), 'term_'.$group_field -> term_id);
                        }
                    }
                }
            }
        }

        // Update all branch-slugs
        if(!empty($this -> old_slug_before_save) && $this -> old_slug_before_save != $term -> slug) {
            global $wpdb;

            // Update branch-slug with product data
            $q  = 'UPDATE '.$wpdb -> postmeta.' AS pm';
            $q .= ' INNER JOIN '.$wpdb ->posts.' AS p ON p.id = pm.post_id';
            $q .= ' SET pm.meta_value=REPLACE(pm.meta_value, "'.$this -> old_slug_before_save.'", "'.$tax_slug.'")';
            $q .= ' WHERE pm.meta_key IN (
                SELECT post_excerpt FROM '.$wpdb -> posts.'
                WHERE post_type="ap_custom_field"
                AND post_content LIKE "%'.addslashes('s:4:"type";s:8:"taxonomy"').'%" AND post_content LIKE "%'
                .addslashes('s:8:"taxonomy";s:9:"ap_branch"').'%"
            )';
            $q  .= ' AND(pm.meta_value = "'.$this -> old_slug_before_save.'" OR pm.meta_value LIKE "%\"'
                .$this -> old_slug_before_save.'\"%")';
            $wpdb -> query($q);
            wp_reset_query();

            // Update branch-slug associated to category
            $q  = 'UPDATE '.$wpdb -> termmeta.' AS tm';
            $q .= ' INNER JOIN '.$wpdb ->term_taxonomy.' AS tt ON tt.term_id = tm.term_id AND tt.taxonomy="ap_category"';
            $q .= ' INNER JOIN '.$wpdb ->terms.' AS t ON t.term_id = tm.term_id';
            $q .= ' SET tm.meta_value=REPLACE(tm.meta_value, "'.$this -> old_slug_before_save.'", "'.$tax_slug.'")';
            $q .= ' WHERE tm.meta_key = "'.$this -> get_taxonomy_name().'"';
            $q .= ' AND tm.meta_value LIKE \'%"'.$this -> old_slug_before_save.'"%\'';
            $wpdb -> query($wpdb -> prepare($q));
            wp_reset_query();
            $this -> old_slug_before_save   = '';
        }
    }

    public function manage_edit_columns($columns){
        $columns        = parent::manage_edit_columns($columns);
        $pos            = array_search('name', array_keys($columns)) + 1;
        $new_columns    = array('group_field_assigned' => __('Group Fields Assigned', 'advanced-product'));

        return array_merge(
            array_slice($columns, 0, $pos),
            $new_columns,
            array_slice($columns, $pos)
        );

    }

    public function manage_custom_column($content, $column, $term_id ){
        $content    = parent::manage_custom_column($content, $column, $term_id);
        if($column == 'group_field_assigned'){
            $fval   = get_field( $column, 'term_'.$term_id );

            if(!empty($fval) && count($fval)){
                foreach($fval as $i => $slug){
                    $term_by    = 'slug';
                    $term       = get_term_by($term_by, $slug, 'ap_group_field');

                    if(!is_wp_error($term) && !empty($term)){
                        $content    .= '<a href="term.php?taxonomy=ap_group_field&post_type=ap_product&tag_ID='
                            .$term -> term_id.'">'.$term -> name.'</a>';
                        if($i < count($fval) - 1){
                            $content    .= ', ';
                        }
                    }
                }
            }
        }
        return $content;
    }

    /**
     * Removes the default taxonomy metaboxes from the edit screen.
     * We use the advanced custom fields instead and sync the data.
     */
    public function remove_taxonomy_metaboxes(){
        /* Remove meta box is tag */
        \remove_meta_box( 'tagsdiv-'.$this -> get_taxonomy_name(), 'ap_product', 'normal' );
        /* Remove meta box is category */
        \remove_meta_box( $this -> get_taxonomy_name().'div', 'ap_product', 'normal' );
    }
}