<?php

defined('TEMPLAZA_FRAMEWORK');

use TemPlazaFramework\CSS;
use TemPlazaFramework\Functions;
use TemPlazaFramework\Templates;

$tzautoshowroom_id             = isset($atts['id'])?$atts['id']:time();
$tzautoshowroom_custom_class   = isset($atts['custom-container-class'])?' '.$atts['custom-container-class']:'';
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $tzautoshowroom_options = array();
}else{
    $tzautoshowroom_options            = Functions::get_theme_options();
}
$tzautoshowroom_post_type       = get_post_type(get_the_ID());
$prefix                 = 'blog-single';

$tzautoshowroom_show_thumbnail         = isset($tzautoshowroom_options[$prefix.'-thumbnail'])?filter_var($tzautoshowroom_options[$prefix.'-thumbnail'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_tag               = isset($tzautoshowroom_options[$prefix.'-tag'])?filter_var($tzautoshowroom_options[$prefix.'-tag'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_meta              = isset($tzautoshowroom_options[$prefix.'-meta'])?filter_var($tzautoshowroom_options[$prefix.'-meta'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_date              = isset($tzautoshowroom_options[$prefix.'-date'])?filter_var($tzautoshowroom_options[$prefix.'-date'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_share             = isset($tzautoshowroom_options[$prefix.'-share'])?filter_var($tzautoshowroom_options[$prefix.'-share'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_title             = isset($tzautoshowroom_options[$prefix.'-title'])?filter_var($tzautoshowroom_options[$prefix.'-title'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_author            = isset($tzautoshowroom_options[$prefix.'-author'])?filter_var($tzautoshowroom_options[$prefix.'-author'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_related           = isset($tzautoshowroom_options[$prefix.'-related'])?filter_var($tzautoshowroom_options[$prefix.'-related'], FILTER_VALIDATE_BOOLEAN):false;
$tzautoshowroom_show_comment           = isset($tzautoshowroom_options[$prefix.'-comment'])?filter_var($tzautoshowroom_options[$prefix.'-comment'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_category          = isset($tzautoshowroom_options[$prefix.'-category'])?filter_var($tzautoshowroom_options[$prefix.'-category'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_description       = isset($tzautoshowroom_options[$prefix.'-description'])?filter_var($tzautoshowroom_options[$prefix.'-description'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_comment_count     = isset($tzautoshowroom_options[$prefix.'-comment-count'])?filter_var($tzautoshowroom_options[$prefix.'-comment-count'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_post_view         = isset($tzautoshowroom_options[$prefix.'-post-view'])?filter_var($tzautoshowroom_options[$prefix.'-post-view'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_show_post_next_preview = isset($tzautoshowroom_options[$prefix.'-next-preview'])?filter_var($tzautoshowroom_options[$prefix.'-next-preview'], FILTER_VALIDATE_BOOLEAN):false;

$tzautoshowroom_blog_slider_autoplay   = isset($tzautoshowroom_options['blog-slider-autoplay'])?filter_var($tzautoshowroom_options['blog-slider-autoplay'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_blog_thumbnail_size    = isset($tzautoshowroom_options[$prefix.'-thumbnail-size'])?$tzautoshowroom_options[$prefix.'-thumbnail-size']:'large';
$tzautoshowroom_blog_thumbnail_effect  = isset($tzautoshowroom_options[$prefix.'-thumbnail-effect'])?$tzautoshowroom_options[$prefix.'-thumbnail-effect']:'none';

$tzautoshowroom_blog_slider_animation  = isset($tzautoshowroom_options['blog-slider-animation'])?$tzautoshowroom_options['blog-slider-animation']:'';
$tzautoshowroom_blog_slider_nav        = isset($tzautoshowroom_options['blog-slider-nav'])?filter_var($tzautoshowroom_options['blog-slider-nav'], FILTER_VALIDATE_BOOLEAN):true;
$tzautoshowroom_blog_slider_kenburns   = isset($tzautoshowroom_options['blog-slider-kenburns'])?filter_var($tzautoshowroom_options['blog-slider-kenburns'], FILTER_VALIDATE_BOOLEAN):true;

$tzautoshowroom_blog_slider_options = '';
if($tzautoshowroom_blog_slider_autoplay == true){
    $tzautoshowroom_blog_slider_options .='autoplay: true; ';
}
if($tzautoshowroom_blog_slider_animation != ''){
    $tzautoshowroom_blog_slider_options .='animation: '.$tzautoshowroom_blog_slider_animation. '';
}
if ( have_posts() ) : while (have_posts()) : the_post() ;
    if ( !empty( get_the_content() ) ){
        $tag_class = 'uk-margin-medium-top ';
    }else{
        $tag_class = '';
    }
?>
<div class="templaza-blog">
    <div id="templaza-single-<?php echo esc_attr($tzautoshowroom_id); ?>" class="templaza-single templaza-single-<?php
    echo esc_attr($tzautoshowroom_post_type.' '.$tzautoshowroom_custom_class); ?> templaza-blog-body">
        <?php
            do_action('templaza_set_postviews',get_the_ID());
            ?>
            <div id="post-<?php the_ID(); ?>" <?php post_class('templaza-blog-item'); ?>>
                <div class="templaza-blog-item-wrap">
                    <div class="templaza-blog-item-content templaza-archive-item ">
                        <div class="templaza-single-content ">
                            <?php
                            if ($tzautoshowroom_show_thumbnail
                                && has_post_thumbnail()
                                && (
                                    has_post_format('gallery')  ||
                                    has_post_format('image')  ||
                                    has_post_format('video') ||
                                    has_post_format('audio') ||
                                    has_post_format()==false ) ): ?>
                                <div class="templaza-single-feature">
                                    <?php
                                    if (has_post_format('gallery')){
                                        do_action('templaza_gallery_post');
                                    }

                                    if(has_post_thumbnail() && empty(has_post_format('gallery')) && empty(has_post_format('audio'))
                                        && empty(has_post_format('video')) && empty(has_post_format('quote'))&& empty(has_post_format('link'))){
                                        do_action('templaza_image_post');
                                    }
                                    if (has_post_format('video')){
                                        do_action('templaza_video_post');
                                    }
                                    if (has_post_format('audio')){
                                        do_action('templaza_audio_post');
                                    }

                                    ?>
                                </div>
                            <?php
                            endif;
                            ?>
                            <div class="templaza-single-description">
                                <?php
                                if (has_post_format('link')){

                                    ?>
                                    <div class=" uk-margin-medium-bottom">
                                        <?php
                                        do_action('templaza_link_post');
                                        ?>
                                    </div>
                                    <?php
                                }
                                if (has_post_format('quote')) {
                                    ?>
                                    <div class="uk-margin-medium-bottom">
                                        <?php
                                        do_action('templaza_quote_post');
                                        ?>
                                    </div>
                                    <?php
                                }
                                do_action('templaza_single_meta_post');
                                $tag_cl= '';
                            if ( !empty( get_the_content() ) ) {
                                $tag_cl = ' ';
                                the_content();
                                wp_link_pages();
                                ?>
                                <div class="clr "></div>
                                <?php
                            }
                                ?>

                                <?php
                                if ($tzautoshowroom_show_tag && has_tag() && get_the_tag_list() || $tzautoshowroom_show_share !=false) {
                                    ?>
                                    <div class="templaza-single-share-box <?php echo esc_attr($tag_cl); ?> uk-flex uk-flex-between uk-flex-middle">
                                    <?php
                                    if ($tzautoshowroom_show_tag && has_tag() && get_the_tag_list()){
                                        do_action('templaza_single_tag_post');
                                    }
                                    if($tzautoshowroom_show_share) {
                                        do_action('templaza_share_post');
                                    }
                                    ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <?php
                        $post_nav = posts_nav_link();
                        if($tzautoshowroom_show_post_next_preview){
                        ?>
                            <div class="templaza-single-next-preview templaza-single-box">
                                <?php
                                do_action('templaza_single_next_post');
                                ?>
                            </div>
                        <?php
                        }
                        if($tzautoshowroom_show_author && get_the_author_meta('description')){
                            ?>
                            <div class="templaza-single-author templaza-single-box">
                                <?php
                                do_action('templaza_single_author_post');
                                ?>
                            </div>
                        <?php
                        }
                        if($tzautoshowroom_show_related){
                            ?>
                            <div class="templaza-single-related templaza-single-box">
                                <?php
                                do_action('templaza_single_related_post');
                                ?>
                            </div>
                        <?php
                        }
                        if($tzautoshowroom_show_comment && comments_open()){
                            ?>
                            <div class="templaza-single-comment templaza-single-box">
                                <?php
                            comments_template( '', true );
                            ?>
                            </div>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php
        endwhile; // end while ( have_posts )

        ?>
    </div>
</div>
<?php
endif; // end if ( have_posts )