<?php
global $content_width;
if ( ! isset( $content_width ) ) {
	$content_width = 580;
}
if ( ! function_exists( 'tzautoshowroom_basic_fonts_url' ) ) {
	function tzautoshowroom_basic_fonts_url()
	{
		$tzautoshowroom_fonts_url = '';
		$tzautoshowroom_font_families = array();
		$font_subsets = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by Barlow, translate this to 'off'. Do not translate into your own language. */
		if ('off' !== esc_html_x('on', 'Nunito: on or off', 'tzautoshowroom')) {
			$tzautoshowroom_font_families[] = 'Nunito:400,500,600,700,800';
		}

		/* translators: If there are characters in your language that are not supported by Saira, translate this to 'off'. Do not translate into your own language. */
		if ('off' !== esc_html_x('on', 'Merriweather: on or off', 'tzautoshowroom')) {
			$tzautoshowroom_font_families[] = 'Merriweather:300,400';
		}

		if ($tzautoshowroom_font_families) {

			$tzautoshowroom_query_args = array(
				'family' => urlencode(implode('|', $tzautoshowroom_font_families)),
				'subset' => urlencode($font_subsets),
			);

			$tzautoshowroom_fonts_url = add_query_arg($tzautoshowroom_query_args, 'https://fonts.googleapis.com/css');
		}
		return esc_url_raw($tzautoshowroom_fonts_url);
	}
}

if ( !function_exists('tzautoshowroom_basic_continue_reading_text') ) {
	function tzautoshowroom_basic_continue_reading_text() {
		$continue_reading = sprintf(
		/* translators: %s: Name of current post. */
			esc_html__( 'Continue reading %s', 'tzautoshowroom' ),
			the_title( '<span class="screen-reader-text">', '</span>', false )
		);

		return $continue_reading;
	}
}