<?php

if ( ! function_exists( 'kropp_core_add_custom_font_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_custom_font_widget( $widgets ) {
		$widgets[] = 'KroppCore_Custom_Font_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_custom_font_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Custom_Font_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'kropp_core_custom_font',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'kropp_core_custom_font' );
				$this->set_name( esc_html__( 'Kropp Custom Font', 'kropp-core' ) );
				$this->set_description( esc_html__( 'Add a custom font element into widget areas', 'kropp-core' ) );
			}
		}

		public function render( $atts ) {
			echo KroppCore_Custom_Font_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
