(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.kropp_core_cards_gallery = {};

	$( window ).on(
		'load',
		function () {
			qodefCardsGallery.init();
		}
	);

	var qodefCardsGallery = {
		init: function () {
			this.holder = $( '.qodef-cards-gallery' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder = $( this );

						qodefCardsGallery.initItem( $holder );

						if ( $holder.hasClass( 'qodef-appear-animation' ) && ! qodefCore.html.hasClass( 'touchevents' ) ) {
							qodefCore.qodefIsInViewport.check(
								$holder,
								function () {
									$holder.addClass( 'qodef-appeared' );
								}
							);
						}

						$( window ).on(
							'resize',
							function () {
								qodefCardsGallery.initArrow( $holder );
							}
						);
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefCardsGallery.initCards( $currentItem );
			qodefCardsGallery.initArrow( $currentItem );
		},
		initCards: function ( $holder ) {
			var $cards 	  = $holder.find( '.qodef-m-card' );
			var $fakeCard = $holder.find( '.qodef-m-fake-card' );
			var $arrowPointer = $holder.find( '.qodef-cards-arrow' );

			// add initial active class
			$cards.last().addClass( 'qodef-active' );

			// add initial arrow skin
			var $arrowSkin = $cards.last().data( 'arrow-skin' );

			if ( typeof $arrowSkin !== 'undefined' ) {
				var arrowClass = 'qodef--' + $arrowSkin;
				$arrowPointer.addClass( arrowClass );
			}

			$cards.each(
				function () {
					var $card = $( this );

					$card.on(
						'click',
						function () {
							if ( $cards.is( $card ) ) {

								// active class change
								var $thisCard = $( this );

								if ( $thisCard.hasClass( 'qodef-active' ) ) {
									$thisCard.removeClass( 'qodef-active' );
									$thisCard.siblings().addClass( 'qodef-active' );
								} else {
									$card.siblings().removeClass( 'qodef-active' );
									$card.addClass( 'qodef-active' );
								}

								// arrow skin change
								var $arrowPointer = $card.parent( '.qodef-e-inner' ).next( '.qodef-m-fake-card' ).find( '.qodef-cards-arrow' );
								$arrowPointer.removeClass( 'qodef--light qodef--dark' );

								var $cardActive = $holder.find( '.qodef-m-card.qodef-active' );

								var $arrowSkin = $cardActive.data( 'arrow-skin' );

								if ( typeof $arrowSkin !== 'undefined' ) {

									var arrowClass = 'qodef--' + $arrowSkin;
									$arrowPointer.addClass( arrowClass );
								}

								$cards = $holder.find( '.qodef-m-card' );

								return false;
							}
						}
					);
				}
			);
		},
		initArrow: function ( $holder ) {

			$holder.each(
				function () {
					var $cardsHolder = $( this );

					if ( $cardsHolder.hasClass( 'qodef-orientation--right' ) ) {

					} else if ( $cardsHolder.hasClass( 'qodef-orientation--left' ) ) {
						var $cardsHolderLeftWidth = $cardsHolder.outerWidth();
						var $arrowLeft = $cardsHolder.find( '.qodef-cards-arrow' );
						var $arrowLeftWidth = $arrowLeft.width();
						var $arrowLeftFix = 35;
						var $lastLeftCard = $cardsHolder.find('.qodef-m-card:first-child');
						var $lastLeftCardWidth = $lastLeftCard.outerWidth();

						$arrowLeft.css(
							{
								right: $cardsHolderLeftWidth - $lastLeftCardWidth - $arrowLeftWidth - $arrowLeftFix,
							}
						);
					}
				}
			);

			if ( $holder.hasClass( 'qodef-orientation--right' ) ) {

				var $cards = $holder.find( '.qodef-m-card' );
			}
		}
	};

	qodefCore.shortcodes.kropp_core_cards_gallery.qodefCardsGallery = qodefCardsGallery;

})( jQuery );
