<?php
$quote_meta = get_post_meta( get_the_ID(), 'qodef_post_format_quote_text', true );
$quote_text = ! empty( $quote_meta ) ? $quote_meta : get_the_title();

if ( ! empty( $quote_text ) ) {
	$quote_author     = get_post_meta( get_the_ID(), 'qodef_post_format_quote_author', true );
    $quote_author_position     = get_post_meta( get_the_ID(), 'qodef_post_format_quote_author_position', true );
	$title_tag        = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h3';
	$author_title_tag = isset( $author_title_tag ) && ! empty( $author_title_tag ) ? $author_title_tag : 'span';
	?>
	<div class="qodef-e-quote">
    <div class="qodef-e-quote-label">
        <?php esc_html_e('Quote', 'kropp');?>
    </div>
    <div class="qodef-quote-text-holder">
        <<?php echo esc_attr( $title_tag ); ?> class="qodef-e-quote-text">
            <span class="qodef-e-quote-sign">
                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26">
                    <g transform="translate(-268 -1379)">
                        <rect width="26" height="2" transform="translate(268 1391)" fill="currentColor"/>
                        <rect width="26" height="2" transform="translate(282 1379) rotate(90)" fill="currentColor"/>
                    </g>
                </svg>
            </span>
            <?php echo esc_html( $quote_text ); ?>
        </<?php echo esc_attr( $title_tag ); ?>>
    </div>
    <div class="qodef-e-author-holder">
        <?php if ( ! empty( $quote_author ) ) { ?>
            <<?php echo esc_attr( $author_title_tag ); ?> class="qodef-e-quote-author"><?php echo esc_html( $quote_author ); ?></<?php echo esc_attr( $author_title_tag ); ?>>
        <?php } ?>
        <?php if ( ! empty( $quote_author ) && ! empty( $quote_author_position ) ) { ?>
            <span class="qodef-e-quote-author-separator">/</span>
        <?php } ?>
        <?php if ( ! empty( $quote_author_position ) ) { ?>
            <span class="qodef-e-quote-author-position"><?php echo esc_html( $quote_author_position ); ?></span>
        <?php } ?>
    </div>
    <div class="qodef-e-quote-mark">
        <svg xmlns="http://www.w3.org/2000/svg" width="65.029" height="46.735" viewBox="0 0 65.029 46.735">
            <path d="M12.073,56.235h13.72l9.147-18.294V10.5H7.5V37.941H21.22Zm36.588,0h13.72l9.147-18.294V10.5H44.088V37.941h13.72Z" transform="translate(-7 -10)" fill="none" stroke="currentColor" stroke-width="1"/>
        </svg>
    </div>
    <?php if ( ! is_single() ) { ?>
			<a itemprop="url" class="qodef-e-quote-url" href="<?php the_permalink(); ?>"></a>
		<?php } ?>
	</div>
<?php } ?>
