<?php

if ( ! function_exists( 'kropp_core_add_title_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function kropp_core_add_title_widget( $widgets ) {
		$widgets[] = 'KroppCore_Title_Widget';

		return $widgets;
	}

	add_filter( 'kropp_core_filter_register_widgets', 'kropp_core_add_title_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class KroppCore_Title_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'kropp_core_title_widget' );
			$this->set_name( esc_html__( 'Kropp Title', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Add title element into widget areas', 'kropp-core' ) );
            $this->set_widget_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'intro_text',
                    'title'      => esc_html__( 'Into Text', 'kropp-core' ),
                )
            );
			$this->set_widget_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'kropp-core' ),
					'default_value' => esc_html__( 'Title', 'kropp-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Title Tag', 'kropp-core' ),
					'options'    => kropp_core_get_select_type_options_pool( 'title_tag' ),
				)
			);
            $this->set_widget_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'show_arrow_pointer',
                    'title'         => esc_html__( 'Show Arrow Pointer', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                )
            );
            $this->set_widget_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'show_arrow_after_title',
                    'title'         => esc_html__( 'Show Arrow After Title', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                )
            );
            $this->set_widget_option(
                array(
                    'field_type'    => 'text',
                    'name'          => 'title_link',
                    'title'         => esc_html__( 'Title Link', 'kropp-core' ),
                )
            );
            $this->set_widget_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'title_link_target',
                    'title'         => esc_html__( 'Title Link Target', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'link_target', false ),
                    'default_value' => '_self',
                )
            );
            $this->set_widget_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'title_link_with_underline',
                    'title'         => esc_html__( 'Title Link With Underline', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                )
            );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'margin_bottom',
					'title'      => esc_html__( 'Bottom Margin', 'kropp-core' ),
				)
			);
		}

		public function render( $atts ) {
		    $intro_text             = $atts['intro_text'];
			$title                  = $atts['title'];
			$show_arrow_pointer     = $atts['show_arrow_pointer'];
			$show_arrow_after_title = $atts['show_arrow_after_title'];
			$title_tag              = ! empty( $atts['title_tag'] ) ? $atts['title_tag'] : 'h4';
            $title_link             = $atts['title_link'];
            $title_link_target      = $atts['title_link_target'];
			$title_styles           = $this->get_title_styles( $atts );
            $link_classes           = $this->get_link_classes( $atts );
			?>
            <div class="qodef-widget-title-holder">
                <?php if ( ! empty( $intro_text ) ) : ?>
                <p class="qodef-intro-text"><?php echo esc_html( $intro_text ); ?></p>
                <?php endif; ?>

                <?php if ( ! empty( $title ) ) : ?>
                    <?php echo '<' . esc_attr( $title_tag ); ?> class="qodef-widget-title" <?php qode_framework_inline_style( $title_styles ); ?>>
                        <?php if ( ! empty( $show_arrow_pointer ) && 'yes' === $show_arrow_pointer ) : ?>
                            <?php kropp_core_render_svg_icon('arrow-pointer'); ?>
                        <?php endif; ?>
                        <?php if ( ! empty( $title_link ) ) : ?>
                            <a <?php qode_framework_class_attribute( $link_classes ); ?> href="<?php echo esc_url( $title_link ); ?>" target="<?php echo esc_attr( $title_link_target ); ?>">
                        <?php endif; ?>
                            <?php echo esc_html( $title ); ?>
                            <?php if ( ! empty( $show_arrow_after_title ) && 'yes' === $show_arrow_after_title ) : ?>
                                <?php kropp_core_render_svg_icon('arrow-pointer-filled'); ?>
                            <?php endif; ?>
                        <?php if ( ! empty( $title_link ) ) : ?>
                            </a>
                        <?php endif; ?>
                    <?php echo '</' . esc_attr( $title_tag ); ?>>
                <?php endif; ?>
            </div>
			<?php
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			$margin_bottom = $atts['margin_bottom'];
			if ( ! empty( $margin_bottom ) ) {
				if ( qode_framework_string_ends_with_space_units( $margin_bottom ) ) {
					$styles[] = 'margin-bottom: ' . $margin_bottom;
				} else {
					$styles[] = 'margin-bottom: ' . intval( $margin_bottom ) . 'px';
				}
			}

			return implode( ';', $styles );
		}

        private function get_link_classes( $atts ) {
            $link_classes              = array();
            $title_link_with_underline = $atts['title_link_with_underline'];

            $link_classes[] = 'qodef-title-link';
            $link_classes[] = ! empty( $title_link_with_underline ) ? 'qodef-link-with-underline--' . $title_link_with_underline : '';

            return implode( ' ', $link_classes );
        }
	}
}
