<?php

if ( ! function_exists( 'kropp_core_add_section_title_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function kropp_core_add_section_title_shortcode( $shortcodes ) {
		$shortcodes[] = 'KroppCore_Section_Title_Shortcode';

		return $shortcodes;
	}

	add_filter( 'kropp_core_filter_register_shortcodes', 'kropp_core_add_section_title_shortcode' );
}

if ( class_exists( 'KroppCore_Shortcode' ) ) {
	class KroppCore_Section_Title_Shortcode extends KroppCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( KROPP_CORE_SHORTCODES_URL_PATH . '/section-title' );
			$this->set_base( 'kropp_core_section_title' );
			$this->set_name( esc_html__( 'Section Title', 'kropp-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds section title element', 'kropp-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'kropp-core' ),
					'default_value' => esc_html__( 'Title Text', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'kropp-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'kropp-core' ),
					'group'       => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_title_break_words',
					'title'         => esc_html__( 'Disable Title Line Break', 'kropp-core' ),
					'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 1024 and lower', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'kropp-core' ),
					'group'      => esc_html__( 'Title Style', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'title_decoration',
                    'title'         => esc_html__( 'Title Decoration', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'group'         => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'title_background_text',
                    'title'      => esc_html__( 'Title Background Text', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'title_background_text_size',
                    'title'      => esc_html__( 'Title Background Text Size', 'kropp-core' ),
                    'options'    => array(
                        ''    => esc_html__( 'Default', 'kropp-core' ),
                        'big' => esc_html__( 'Big', 'kropp-core' ),
                    ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'background_text_outline_color',
                    'title'      => esc_html__( 'Background Text Outline Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Title Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear',
                    'title'         => esc_html__( 'Background Text Appear Animation', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Title Custom Link', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'subtitle',
                    'title'      => esc_html__( 'Subtitle', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'subtitle_tag',
                    'title'         => esc_html__( 'Subtitle Tag', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'title_tag' ),
                    'default_value' => 'h5',
                    'group'         => esc_html__( 'Subtitle Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'subtitle_color',
                    'title'      => esc_html__( 'Subtitle Color', 'kropp-core' ),
                    'group'      => esc_html__( 'Subtitle Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'subtitle_margin_top',
                    'title'      => esc_html__( 'Subtitle Margin Top', 'kropp-core' ),
                    'group'      => esc_html__( 'Subtitle Style', 'kropp-core' ),
                )
            );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'kropp-core' ),
					'options'       => kropp_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'kropp-core' ),
					'default_value' => esc_html__( 'Contrary to popular belief, Lorem Ipsum is not simply random text.', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'kropp-core' ),
					'group'      => esc_html__( 'Text Style', 'kropp-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'text_max_width',
                    'title'       => esc_html__( 'Text Max Width', 'kropp-core' ),
                    'description' => esc_html__( 'Text max width value on laptops and desktops', 'kropp-core' ),
                    'group'       => esc_html__( 'Text Style', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'text',
                    'name'          => 'button_text',
                    'title'         => esc_html__( 'Button Text', 'kropp-core' ),
                    'default_value' => esc_html__( 'See More', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'button_link',
                    'title'      => esc_html__( 'Button Link', 'kropp-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'button_target',
                    'title'         => esc_html__( 'Target', 'kropp-core' ),
                    'options'       => kropp_core_get_select_type_options_pool( 'link_target' ),
                    'default_value' => '_self',
                )
            );
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'kropp-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'kropp-core' ),
						'left'   => esc_html__( 'Left', 'kropp-core' ),
						'center' => esc_html__( 'Center', 'kropp-core' ),
						'right'  => esc_html__( 'Right', 'kropp-core' ),
					),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']           = $this->get_holder_classes( $atts );
			$atts['title']                    = $this->get_modified_title( $atts );
			$atts['title_styles']             = $this->get_title_styles( $atts );
			$atts['title_background_styles']  = $this->get_title_background_styles( $atts );
            $atts['title_background_classes'] = $this->get_title_background_classes( $atts );
            $atts['subtitle_styles']          = $this->get_subtitle_styles( $atts );
			$atts['text_styles']              = $this->get_text_styles( $atts );

			return kropp_core_get_template_part( 'shortcodes/section-title', 'templates/section-title', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-section-title';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
			$holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';
            $holder_classes[] = ! empty( $atts['title_decoration'] ) ? 'qodef-title-decoration--' . $atts['title_decoration'] : '';
            $holder_classes[] = ! empty( $atts['title_background_text_size'] ) ? 'qodef-title-background-text-size--' . $atts['title_background_text_size'] : '';
            $holder_classes[] = ! empty( $atts['title_background_text'] ) ? 'qodef-title-background-text--yes' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_modified_title( $atts ) {
			$title = $atts['title'];

			if ( ! empty( $title ) && ! empty( $atts['line_break_positions'] ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );

				foreach ( $line_break_positions as $position ) {
					$position = intval( $position );
					if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
						$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

        private function get_title_background_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['background_text_outline_color'] ) {
                $styles[] = '-webkit-text-stroke-color:' . $atts['background_text_outline_color'];
            }

            return $styles;
        }

        private function get_title_background_classes( $atts ) {
            $title_classes = array();

            $title_classes[] = 'qodef-m-title-background-text';
            $title_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--custom-chars-splitting-animation' : '';

            return implode( ' ', $title_classes );
        }

        private function get_subtitle_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['subtitle_margin_top'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_top'] ) ) {
                    $styles[] = 'margin-top: ' . $atts['subtitle_margin_top'];
                } else {
                    $styles[] = 'margin-top: ' . intval( $atts['subtitle_margin_top'] ) . 'px';
                }
            }

            if ( ! empty( $atts['subtitle_color'] ) ) {
                $styles[] = 'color: ' . $atts['subtitle_color'];
            }

            return $styles;
        }

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( '' !== $atts['text_max_width'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_max_width'] ) ) {
					$styles[] = 'max-width: ' . $atts['text_max_width'];
				} else {
					$styles[] = 'max-width: ' . intval( $atts['text_max_width'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}
	}
}
