<?php

if ( ! function_exists( 'kropp_core_add_nav_menu_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function kropp_core_add_nav_menu_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'nav_menu_item' ),
				'type'  => 'nav-menu',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'checkbox',
					'name'       => 'qodef-enable-mega-menu',
					'title'      => esc_html__( 'Enable Mega Menu', 'kropp-core' ),
					'options'    => array(
						'enable' => esc_html__( 'Enable', 'kropp-core' ),
					),
					'args'       => array(
						'depth' => 0,
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'checkbox',
					'name'       => 'qodef-enable-anchor-link',
					'title'      => esc_html__( 'Enable Anchor Link', 'kropp-core' ),
					'options'    => array(
						'enable' => esc_html__( 'Enable', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef-menu-item-appearance',
					'title'      => esc_html__( 'Menu Item Appearance', 'kropp-core' ),
					'options'    => array(
						'none'       => esc_html__( 'None', 'kropp-core' ),
						'hide-item'  => esc_html__( 'Hide Item', 'kropp-core' ),
						'hide-link'  => esc_html__( 'Hide Link', 'kropp-core' ),
						'hide-label' => esc_html__( 'Hide Label', 'kropp-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'iconpack',
					'name'       => 'qodef-menu-item-icon-pack',
					'title'      => esc_html__( 'Icon Pack', 'kropp-core' ),
					'args'       => array(
						'width' => 'thin',
					),
				)
			);

			$custom_sidebars = kropp_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$page->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef-enable-mega-menu-widget',
						'title'       => esc_html__( 'Custom Sidebar', 'kropp-core' ),
						'description' => esc_html__( 'Choose a custom sidebar to display on wide menu', 'kropp-core' ),
						'options'     => $custom_sidebars,
						'args'        => array(
							'depth' => 1,
						),
					)
				);
			}
		}
	}

	add_action( 'qode_framework_action_custom_nav_menu_fields', 'kropp_core_add_nav_menu_options' );
}
