(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			if ( document.visibilityState === 'visible' ) {
				qodefSpinner.windowLoaded = true;
			} else {
				document.addEventListener(
					'visibilitychange',
					function () {
						if ( document.visibilityState === 'visible' ) {
							qodefSpinner.windowLoaded = true;
						}
					}
				);
			}
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefSpinner.init( isEditMode );
			}
		}
	);

	var qodefSpinner = {
		holder: '',
		windowLoaded: false,
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner.qodef-layout--predefined' );

			if ( this.holder.length ) {
				qodefSpinner.animateSpinner(
					isEditMode,
					this.holder
				);
				qodefSpinner.fadeOutAnimation();
			}
		},
		animateSpinner: function ( isEditMode, $holder ) {
			if ( isEditMode ) {
				qodefSpinner.fadeOutLoader();
			} else {
				var $contentSvg = $( '.qodef-spinner-target sup.qodef-title-decoration' );

				var $svgHolder       = $holder.find( '.qodef-m-spinner' ),
					$lines           = $svgHolder.find( '.qodef-svg--spinner-plus line' ),
					startAngles      = [],
					endAngles        = [],
					delays           = [],
					loopsNum         = 2,
					currentIteration = 0,

					$bgHolder        = $holder.find( '.qodef-m-inner' ),
					contentSvgWidth,
					loaderSvgLeft,
					loaderSvgTop;

				if ( $contentSvg.length ) {//in case loader is positioned in the page content as well
					function calculateLogoPosition() {
						var contentSvgStyles = $contentSvg[0].getBoundingClientRect(),
							contentSvgLeft   = contentSvgStyles.left,
							contentSvgTop    = contentSvgStyles.top;

						contentSvgWidth = contentSvgStyles.width;
						loaderSvgLeft   = contentSvgLeft;
						loaderSvgTop    = contentSvgTop;
					}

					calculateLogoPosition();

					function animateSpinnerToLogoPosition() {
						gsap.to(
							$svgHolder,
							{
								width: contentSvgWidth,
								top: loaderSvgTop,
								left: loaderSvgLeft,
								xPercent: 0,
								yPercent: 0,
								duration: .5,
							},
						);
					}

					$( window ).resize( function () {
						//calculateLogoPosition();
						//animateSpinnerToLogoPosition();
					} );
				}

				function fadeInSpinner() {
					var tl = gsap.to(
						$svgHolder,
						{
							opacity: 1,
							duration: 1,
							onStart: () => {
								if ( $contentSvg.length ) {//in case loader is positioned in the page content as well
									qodefCore.body.addClass( 'qodef--spiner-custom-behaviour' );
									qodefCore.qodefScroll.disable();
									window.scrollTo(
										0,
										0
									);
								}
							}
						}
					)

					return tl;
				}
				function completeFadeOutSpinnerBackground() {
					var tl = gsap.to(
						$bgHolder,
						{
							backgroundColor: 'rgba(0, 0, 0, 0.000)',
							duration: 2,
							ease: 'power2.in'
						},
					);
					return tl;
				}
				function enablePageInteraction() {
					window.scrollTo(
						0,
						0
					);
					qodefCore.qodefScroll.enable();
					qodefCore.body.addClass( 'qodef--page-loaded' );
				}
				function animateSpinnerToCustomPosition() {
					var tl = gsap.to(
						$svgHolder,
						{
							width: contentSvgWidth,
							top: loaderSvgTop,
							left: loaderSvgLeft,
							xPercent: 0,
							yPercent: 0,
							rotate: '360deg',
							duration: 1.2,
							onStart: () => {
								enablePageInteraction();
							},
						}
					)

					return tl;
				}
				function fadeOutSpinnerCustom() {
					var customTl = gsap.timeline();
						customTl
						//.add(animateSpinnerToCustomPosition())
						.add(completeFadeOutSpinnerBackground(),'.2')
					enablePageInteraction();

					return tl;
				}

				for ( let i = 0; i < $lines.length; i++ ) {
					var compStyle  = getComputedStyle( $lines[i] ),
						startAngle = compStyle.getPropertyValue( '--qodef-rotate-start' ),
						endAngle   = compStyle.getPropertyValue( '--qodef-rotate-end' )

					startAngles.push( startAngle );
					endAngles.push( endAngle );
				}

				gsap.set(
					$lines,
					{
						rotate: ( i ) => startAngles[i],
						svgOrigin: '0 0',
					}
				);

				var tl = gsap.timeline();

				/* fade in */
				if ( $contentSvg.length ) {//in case loader is positioned in the page content as well
					qodefCore.body.addClass( 'qodef--spiner-custom-behaviour' );
					qodefCore.qodefScroll.disable();
					window.scrollTo(
						0,
						0
					);
				}

				tl
				/*.add(fadeInSpinner())*/
				/*.add(spinnerLoop(), '.1')*/

				qodefSpinner.fadeOutLoader();
				enablePageInteraction();
			}
		},
		fadeOutLoader: function ( speed, delay, easing ) {
			var $holder = qodefSpinner.holder.length ? qodefSpinner.holder : $( '#qodef-page-spinner.qodef-layout--predefined' );

			speed  = speed ? speed : 800;
			delay  = delay ? delay : 400;
			easing = easing ? easing : 'swing';

			$holder.delay( delay ).fadeOut(
				speed,
				easing
			);

			$( window ).on(
				'bind',
				'pageshow',
				function ( event ) {
					if ( event.originalEvent.persisted ) {
						$holder.fadeOut(
							speed,
							easing
						);
					}
				}
			);

			setTimeout(
				() => {
					qodef.body.addClass('qodef-spinner--end');
				}, 50
			);
		},
		fadeOutAnimation: function () {

			// Check for fade out animation
			if ( qodefCore.body.hasClass( 'qodef-spinner--fade-out' ) ) {
				var $pageHolder = $( '#qodef-page-wrapper' ),
					$linkItems  = $( 'a' );

				// If back button is pressed, than show content to avoid state where content is on display:none
				window.addEventListener(
					'pageshow',
					function ( event ) {
						var historyPath = event.persisted || (typeof window.performance !== 'undefined' && window.performance.navigation.type === 2);
						if ( historyPath && ! $pageHolder.is( ':visible' ) ) {
							$pageHolder.show();
						}
					}
				);

				$linkItems.on(
					'click',
					function ( e ) {
						var $clickedLink = $( this );

						if (
							e.which === 1 && // check if the left mouse button has been pressed
							$clickedLink.attr( 'href' ).indexOf( window.location.host ) >= 0 && // check if the link is to the same domain
							! $clickedLink.hasClass( 'remove' ) && // check is WooCommerce remove link
							$clickedLink.parent( '.product-remove' ).length <= 0 && // check is WooCommerce remove link
							$clickedLink.parents( '.woocommerce-product-gallery__image' ).length <= 0 && // check is product gallery link
							typeof $clickedLink.data( 'rel' ) === 'undefined' && // check pretty photo link
							typeof $clickedLink.attr( 'rel' ) === 'undefined' && // check VC pretty photo link
							! $clickedLink.hasClass( 'lightbox-active' ) && // check is lightbox plugin active
							(typeof $clickedLink.attr( 'target' ) === 'undefined' || $clickedLink.attr( 'target' ) === '_self') && // check if the link opens in the same window
							$clickedLink.attr( 'href' ).split( '#' )[0] !== window.location.href.split( '#' )[0] // check if it is an anchor aiming for a different page
						) {
							e.preventDefault();

							$pageHolder.fadeOut(
								600,
								'easeOutSine',
								function () {
									window.location = $clickedLink.attr( 'href' );
								}
							);
						}
					}
				);
			}
		}
	};

})( jQuery );

