(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.kropp_core_video_button = {};

	$( document ).ready(
		function () {
			qodefPlayBtnCursorMove.init();
		}
	);

	$( window ).on(
		'resize',
		function () {
			qodefPlayBtnCursorMove.init();
		}
	);

	var qodefPlayBtnCursorMove = {
		init: function () {
			this.holder = $( '.qodef-video-button.qodef--has-img' );
			this.holder.addClass( 'qodef--init' );

			if ( this.holder.length && !qodefCore.html.hasClass('touchevents') && qodef.windowWidth > 1024 ) {
				this.holder.each(
					function () {
						var $thisHolder  		= $( this ),
							$holderWidth		= $thisHolder.width(),
							$holderHeight		= $thisHolder.height(),
							$followElement 		= $thisHolder.find( '.qodef-play-btn' ),
							$followElementWidth = $followElement.width(),
							$btnLink      		= $thisHolder.find( '.qodef-m-play' ),
							$text         		= $thisHolder.find( '.qodef-m-play' ),
							textWidth     		= $text.width(),
							textHeight    		= $text.height(),
							textTop       		= $text.position().top,
							textLeft      		= $text.position().left,
							textBottom    		= textTop + textHeight,
							textRight     		= textLeft + textWidth;

						$followElement.css( {
							'--x': ( $holderWidth - $followElementWidth ) / 2 + 'px',
							'--y': ( $holderHeight - $followElementWidth ) / 2 + 'px',
						} );

						$thisHolder.on(
							'mousemove',
							function ( e ) {

								var posX = e.originalEvent.offsetX;
								var posY = e.originalEvent.offsetY;
								var startFlag    = true;

								if ( (posX >= textLeft) && (posX <= textRight) && (posY >= textTop) && (posY <= textBottom) ) {

									$followElement.removeClass( 'qodef--reset' );

									if ( startFlag ) {
										$followElement.addClass( 'qodef--start' );
										startFlag = false;
									} else {
										setTimeout(
											function () {
												$followElement.removeClass( 'qodef--start' );
											},
											100
										);

									}
									$followElement.css( {
										'--x': posX - $followElementWidth / 2 + 'px',
										'--y': posY - $followElementWidth / 2 + 'px'
									} );
								}
							}
						).on(
							'mouseleave',
							function () {
								$followElement.removeClass( 'qodef--start' );
								$followElement.addClass( 'qodef--reset' );

								$followElement.css( {
									'--x': ( $holderWidth - $followElementWidth ) / 2 + 'px',
									'--y': ( $holderHeight - $followElementWidth ) / 2 + 'px',
								} );
							}
						);
					}
				);
			}
		}
	};

	qodefCore.shortcodes.kropp_core_video_button.qodefPlayBtnCursorMove = qodefPlayBtnCursorMove;
	qodefCore.shortcodes.kropp_core_video_button.qodefMagnificPopup 	   = qodef.qodefMagnificPopup;

})( jQuery );
