(function ( $ ) {
    'use strict';

    qodefCore.shortcodes.kropp_core_banner = {};

    $( document ).ready(
        function () {
            qodefBanner.init();
        }
    );

    var qodefBanner = {
        init: function () {
            this.banners = $( '.qodef-banner' );

            if ( this.banners.length ) {
                this.banners.each(
                    function () {
                        qodefBanner.initItem( $( this ) );
                    }
                );
            }
        },
        initItem: function ( $currentItem ) {
            qodefBanner.bannerParagraphReveal( $currentItem );
        },
        bannerParagraphReveal: function ( $banner ) {
            if ( $banner.hasClass( 'qodef-layout--link-button' ) ) {
                var $bannerParagraph = $banner.find( '.qodef-m-content-inner > .qodef-m-text' );

                if ( $bannerParagraph.length ) {
                    $banner.on(
                        'mouseenter touchstart',
                        function () {
                            qodefBanner.revealParagraph($banner, $bannerParagraph);
                        }
                    );
                    $banner.on(
                        'mouseleave touchend',
                        function () {
                            qodefBanner.revealParagraph($banner, $bannerParagraph);
                        }
                    );
                }
            }
        },
        revealParagraph: function ( $banner, $bannerParagraph ) {

            if ( $bannerParagraph.is( ':visible' ) ) {
                $bannerParagraph.slideUp( 300 );
                $banner.removeClass( 'qodef--hovered' );
            } else {
                $bannerParagraph.slideDown( 300 );
                $banner.addClass( 'qodef--hovered' );
            }
        }
    };

    qodefCore.shortcodes.kropp_core_banner.qodefBanner = qodefBanner;

})( jQuery );
