<?php

if ( ! function_exists( 'kropp_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function kropp_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => KROPP_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'kropp-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'kropp-core' ),
				'icon'        => 'fa fa-cog',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'kropp-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts',
					),
				)
			);

			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'kropp-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'kropp-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'kropp-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'kropp-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type'  => 'googlefont',
					'name'        => 'qodef_choose_google_font',
					'title'       => esc_html__( 'Google Font', 'kropp-core' ),
					'description' => esc_html__( 'Choose Google Font', 'kropp-core' ),
					'args'        => array(
						'include' => 'google-fonts',
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Weight', 'kropp-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts weights for your website. Impact on page load time', 'kropp-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'kropp-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'kropp-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'kropp-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'kropp-core' ),
						'300'  => esc_html__( '300 Light', 'kropp-core' ),
						'300i' => esc_html__( '300 Light Italic', 'kropp-core' ),
						'400'  => esc_html__( '400 Regular', 'kropp-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'kropp-core' ),
						'500'  => esc_html__( '500 Medium', 'kropp-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'kropp-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'kropp-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'kropp-core' ),
						'700'  => esc_html__( '700 Bold', 'kropp-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'kropp-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'kropp-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'kropp-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'kropp-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'kropp-core' ),
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'kropp-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts style for your website. Impact on page load time', 'kropp-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'kropp-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'kropp-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'kropp-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'kropp-core' ),
						'greek'        => esc_html__( 'Greek', 'kropp-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'kropp-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'kropp-core' ),
					),
				)
			);

			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'kropp-core' ),
					'description' => esc_html__( 'Add custom fonts', 'kropp-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'kropp-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_ttf',
					'title'      => esc_html__( 'Custom Font TTF', 'kropp-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_otf',
					'title'      => esc_html__( 'Custom Font OTF', 'kropp-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff',
					'title'      => esc_html__( 'Custom Font WOFF', 'kropp-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff2',
					'title'      => esc_html__( 'Custom Font WOFF2', 'kropp-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_custom_font_name',
					'title'      => esc_html__( 'Custom Font Name', 'kropp-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'kropp_core_action_after_page_fonts_options_map', $page );
		}
	}

	add_action( 'kropp_core_action_default_options_init', 'kropp_core_add_fonts_options', kropp_core_get_admin_options_map_position( 'fonts' ) );
}
