<?php

defined('ADVANCED_PRODUCT') or exit();

use Advanced_Product\AP_Templates;
use Advanced_Product\AP_Functions;
use Advanced_Product\Helper\AP_Product_Helper;
use Advanced_Product\Helper\AP_Custom_Field_Helper;
use TemPlazaFramework\Functions;
if ( !class_exists( 'TemPlazaFramework\TemPlazaFramework' )){
    $templaza_options = array();
}else{
    $templaza_options = Functions::get_theme_options();
}
$widget_heading_style       = isset($templaza_options['widget_box_heading_style'])?$templaza_options['widget_box_heading_style']:'';
$ap_office_price           = isset($templaza_options['ap_product-office-price'])?$templaza_options['ap_product-office-price']:true;
$ap_show_vendor           = isset($templaza_options['ap_product-single-vendor'])?$templaza_options['ap_product-single-vendor']:true;
$ap_office_price_label     = isset($templaza_options['ap_product-office-price-label'])?$templaza_options['ap_product-office-price-label']:'MAKE AN OFFICE PRICE';
$ap_office_price_form      = isset($templaza_options['ap_product-office-price-form'])?$templaza_options['ap_product-office-price-form']:'';
$ap_office_form_custom     = isset($templaza_options['ap_product-office-price-form-custom'])?$templaza_options['ap_product-office-price-form-custom']:'';
$ap_vendor_contact     = isset($templaza_options['ap_product-vendor-contact'])?$templaza_options['ap_product-vendor-contact']:'';
$ap_vendor_title     = isset($templaza_options['ap_product-vendor-contact-label'])?$templaza_options['ap_product-vendor-contact-label']:__('Contact Vendor','tzautoshowroom');
$show_compare_button= get_field('ap_show_archive_compare_button', 'option');
$show_compare_button= $show_compare_button!==false?(bool)$show_compare_button:true;
$show_compare_button= isset($args['show_archive_compare_button'])?(bool)$args['show_archive_compare_button']:$show_compare_button;
$ap_share           = isset($templaza_options['ap_product-single-share'])?$templaza_options['ap_product-single-share']:false;
$ap_share_label     = isset($templaza_options['ap_product-single-share-label'])?$templaza_options['ap_product-single-share-label']:'';

do_action('templaza_set_postviews',get_the_ID());
$author_id = get_post_field( 'post_author', get_the_ID() );
$ap_count = count_user_posts( $author_id,'ap_product' );
$call2buy_value     = get_field('call-to-buy', get_the_ID());
$call2buy = AP_Custom_Field_Helper::get_custom_field_option_by_field_name('call-to-buy');
?>
    <div class="templaza-ap-single uk-article">

        <div id="ap-wrap-content" data-uk-grid>
            <div class="uk-width-expand@m ap-content">
                <div class="ap-single-box ap-single-media">
                    <div class="uk-display-block uk-position-relative">
                        <?php AP_Templates::load_my_layout('single.media'); ?>
                        <div class="ap-single-button-wrap uk-flex uk-flex-middle uk-position-absolute uk-margin uk-margin-right uk-position-top-right" >
                            <?php
                            if($show_compare_button) {
                                AP_Templates::load_my_layout('shortcodes.advanced-product.compare-button', true, false,
                                    array('atts' => array('id' => get_the_ID())));
                            }
                            ?>
                            <?php if($ap_share){ ?>
                                <div class="ap-btn ap-share uk-flex uk-flex-center  uk-flex-middle uk-animation-toggle uk-transition-toggle  uk-margin-small-left  uk-position-relative">
                                    <i class="fas fa-share-alt"></i>
                                    <?php echo esc_html($ap_share_label);?>
                                    <div class="ap-share-item  uk-transition-slide-bottom-small">
                                        <a class="facebook" title="<?php esc_attr_e('Share on Facebook','amanus');?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_the_permalink(get_the_ID())); ?>">
                                            <i class="fab fa-facebook-f"></i>
                                        </a>
                                        <a class="twitter" title="<?php esc_attr_e('Share on Twitter','amanus');?>" target="_blank" href="https://twitter.com/home?status=Check%20out%20this%20article:%20<?php print esc_attr($tweet_title); ?>%20-%20<?php echo urlencode(get_the_permalink(get_the_ID())); ?>">
                                            <i class="fab fa-twitter"></i>
                                        </a>
                                        <?php $templaza_pin_image = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID())); ?>
                                        <a class="pinterest" title="<?php esc_attr_e('Share on Pinterest','amanus');?>"  data-pin-do="skipLink" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_attr($templaza_pin_image); ?>&description=<?php echo urlencode(get_the_title(get_the_ID())); ?>">
                                            <i class="fab fa-pinterest"></i>
                                        </a>
                                        <a class="linkedin" title="<?php esc_attr_e('Share on Linkedin','amanus');?>"  target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php the_permalink(get_the_ID()); ?>">
                                            <i class="fab fa-linkedin-in"></i>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="uk-width-1-3@m ap-templaza-sidebar uk-hidden@m">
                    <div class="ap-sidebar-inner">
                        <div class="ap-single-price-box ap-single-side-box ap-single-box uk-flex uk-flex-middle uk-flex-between">
                            <div class="ap-single-price">
                                <?php
                                AP_Templates::load_my_layout('single.price');
                                ?>
                            </div>
                            <?php if($ap_office_price){ ?>
                                <div class=" hightlight-box ">
                                    <a class="highlight uk-flex uk-flex-center uk-flex-middle" href="#modal-center" data-uk-toggle>
                                        <span>
                                            <?php echo esc_html($ap_office_price_label);?>
                                        </span>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                        <?php
                        AP_Templates::load_my_layout('single.custom-fields');
                        ?>
                        <?php if($call2buy_value){ ?>
                            <div class="call-to-buy uk-flex uk-flex-middle">
                                <i class="fas fa-headphones"></i>
                                <div>
                                    <h4 class="phone uk-margin-remove">
                                        <?php echo esc_html($call2buy_value);?>
                                    </h4>
                                    <p class="uk-margin-remove"><?php esc_html_e('Call our seller to get the best price','tzautoshowroom');?></p>
                                </div>

                            </div>
                        <?php } ?>
                    </div>
                </div>
                <?php AP_Templates::load_my_layout('single.meta');?>

                <div class="ap-single-box ap-single-content">
                    <?php
                    the_content();
                    if(isset($_GET['customfield_layout'])){
                        $ap_single_customfield_layout = $_GET['customfield_layout'];
                    }else {
                        $ap_single_customfield_layout = isset($templaza_options['ap_product-single-customfield-style']) ? $templaza_options['ap_product-single-customfield-style'] : 'style1';
                    }
                    $product_id = get_the_ID();
                    $gfields_assigned   = AP_Custom_Field_Helper::get_group_fields_by_product();
                    if($gfields_assigned && count($gfields_assigned)){
                        foreach ($gfields_assigned as $group) {
                            if($group->slug=='vehicle-content'){
                                $fields = AP_Custom_Field_Helper::get_fields_by_group_fields($group);
                                if($fields && count($fields)) {
                                    ob_start();
                                    foreach ($fields as $field) {
                                        AP_Templates::load_my_layout('single.custom-fields-item-tab', true, false, array(
                                            'field'         => $field,
                                            'product_id'    => $product_id
                                        ));
                                    }
                                    $html = ob_get_contents();
                                    ob_end_clean();

                                    $html = trim($html);
                                }
                                if(!empty($html)){
                                    ?>
                                    <ul data-uk-tab>
                                        <?php echo wp_kses($html,'post');?>
                                    </ul>
                                    <?php
                                }

                                if($fields && count($fields)) {
                                    ?>
                                    <ul class="uk-switcher uk-margin-medium-top">
                                    <?php
                                    foreach ($fields as $field) {

                                        if (!empty($field) && ($acf_f = AP_Custom_Field_Helper::get_custom_field_option_by_id($field -> ID))) {

                                            $f_value    = get_field($acf_f['name'], $product_id);
                                            if(!empty($f_value)){
                                                if($acf_f['type'] !='taxonomy'){
                                                    ?>
                                                    <li>
                                                        <?php
                                                        if($acf_f['type'] == 'file'){
                                                            $file_url   = '';
                                                            if(is_array($f_value)){
                                                                $file_url   = $f_value['url'];
                                                            }elseif(is_numeric($f_value)){
                                                                $file_url   = wp_get_attachment_url($f_value);
                                                            }else{
                                                                $file_url   = $f_value;
                                                            }
                                                            ?>
                                                            <a href="<?php echo esc_url($file_url); ?>" download><?php
                                                                echo esc_html__('Download', 'tzautoshowroom')?></a>
                                                            <?php
                                                        }else{
                                                            ?><?php the_field($acf_f['name'], $product_id); ?>
                                                        <?php } ?>
                                                    </li>
                                                    <?php
                                                }
                                            }
                                        }
                                    }
                                    ?>
                                    </ul>
                                    <?php
                                }
                            }
                        }
                    }
                    ?>

                </div>
                <div class="uk-width-1-3@m ap-templaza-sidebar uk-hidden@m">
                    <?php if($ap_show_vendor){
                        $pageid         = (int)get_option('options_dealership_dealer_page_id',0);
                        $pageid         = !empty($pageid)?$pageid:get_the_ID();
                        $user_login     = get_the_author_meta('user_login');
                        $url            = get_permalink($pageid).$user_login;
                        ?>
                    <div class="ap-single-price-box ap-single-side-box ap-single-author-box ap-single-box">
                        <div class="uk-card">
                            <div class="author-header">
                                <div class="uk-grid-small uk-flex-middle" data-uk-grid>
                                    <div class="uk-width-auto">
                                        <a href="<?php echo esc_url($url);?>">
                                            <img class="uk-border-circle" width="70" height="70" src="<?php echo esc_url( get_avatar_url( get_the_author_meta('ID'),150) ); ?>">
                                        </a>
                                    </div>
                                    <div class="uk-width-expand">
                                        <h3 class="uk-card-title uk-margin-remove-bottom">
                                            <a href="<?php echo esc_url($url);?>">
                                                <?php the_author();?>
                                            </a>
                                        </h3>
                                        <p class="uk-text-meta uk-margin-remove-top"><?php echo esc_html($ap_count);?> <?php esc_html_e('Products','tzautoshowroom');?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="author-description">
                                <?php the_author_meta('description'); ?>
                                <div class="templaza-block-author-social uk-text-meta  uk-margin-top">
                                    <?php do_action('templaza_author_social');?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if(function_exists('wpforms') && $ap_vendor_contact !='') { ?>
                        <div class="widget ap-single-side-box  ap-box ap-single-box">
                            <div class="widget-content">
                                <?php if($ap_vendor_title !=''){
                                    ?>
                                    <h3 class="widget-title ap-group-title is-style-templaza-heading-style3">
                                        <span><?php echo esc_html($ap_vendor_title);?></span>
                                    </h3>
                                    <?php
                                }
                                ?>
                                <div class="ap-group-content">
                                    <?php
                                    echo do_shortcode('[wpforms id="' . $ap_vendor_contact . '"]');
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <div class="templaza-single-comment ap-single-box">
                    <?php comments_template('', true); ?>
                </div>
            </div>
            <div class="uk-width-1-3@m ap-templaza-sidebar uk-visible@m">
                <div class="ap-sidebar-inner">
                    <div class="ap-single-price-box ap-single-side-box ">
                        <div class="ap-single-price">
                            <?php
                            AP_Templates::load_my_layout('single.price');
                            ?>
                        </div>

                        <?php if($ap_office_price){ ?>
                            <div class=" hightlight-box uk-margin-top">
                                <a class="highlight uk-flex uk-flex-center uk-flex-middle" href="#modal-center" data-uk-toggle>
                                    <span>
                                        <?php echo esc_html($ap_office_price_label);?>
                                    </span>
                                </a>
                            </div>
                        <?php } ?>

                    </div>

                    <?php
                    AP_Templates::load_my_layout('single.custom-fields');
                    ?>

                    <?php if($call2buy_value){ ?>
                        <div class="call-to-buy uk-flex uk-flex-middle">
                            <i class="fas fa-headphones"></i>
                            <div>
                                <h4 class="phone uk-margin-remove">
                                    <?php echo esc_html($call2buy_value);?>
                                </h4>
                                <p class="uk-margin-remove"><?php esc_html_e('Call our seller to get the best price','tzautoshowroom');?></p>
                            </div>

                        </div>
                    <?php } ?>

                    <?php if($ap_show_vendor){
                        $pageid         = (int)get_option('options_dealership_dealer_page_id',0);
                        $pageid         = !empty($pageid)?$pageid:get_the_ID();
                        $user_login     = get_the_author_meta('user_login');
                        $url            = get_permalink($pageid).$user_login;
                        ?>
                    <div class="ap-single-price-box ap-single-side-box ap-single-author-box widget">
                        <h3 class="widget-title ap-group-title is-style-templaza-heading-style3">
                            <span><?php esc_html_e('Vendor Profile','tzautoshowroom');?></span>
                        </h3>
                        <div class="uk-card">
                            <div class="author-header">
                                <div class="uk-grid-small uk-flex-middle" data-uk-grid>
                                    <div class="uk-width-auto">
                                        <a href="<?php echo esc_url($url);?>">
                                            <img class="" width="70" height="70" src="<?php echo esc_url( get_avatar_url( get_the_author_meta('ID'),150) ); ?>">
                                        </a>
                                    </div>
                                    <div class="uk-width-expand">
                                        <h3 class="uk-card-title uk-margin-remove-bottom">
                                            <a href="<?php echo esc_url($url);?>">
                                                <?php the_author();?>
                                            </a>
                                        </h3>
                                        <p class="uk-text-meta uk-margin-remove-top"><?php echo esc_html($ap_count);?> <?php esc_html_e('Products','tzautoshowroom');?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="author-description">
                                <?php the_author_meta('description'); ?>
                                <div class="templaza-block-author-social uk-text-meta  uk-margin-top">
                                    <?php do_action('templaza_author_social');?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>

                    <?php if(function_exists('wpforms') && $ap_vendor_contact !='') { ?>
                        <div class="widget ap-single-side-box ap-box">
                            <div class="widget-content">
                                <?php if($ap_vendor_title !=''){
                                    ?>
                                    <h3 class="widget-title ap-group-title is-style-templaza-heading-style3">
                                        <span><?php echo esc_html($ap_vendor_title);?></span>
                                    </h3>
                                    <?php
                                }
                                ?>

                                <div class="ap-group-content">
                                    <?php
                                    echo do_shortcode('[wpforms id="' . $ap_vendor_contact . '"]');
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php
        AP_Templates::load_my_layout('single.related');
        ?>
    </div>
<?php if($ap_office_price){ ?>
    <div id="modal-center" class="uk-flex-top ap-modal" data-uk-modal>
        <div class="uk-modal-dialog uk-modal-body uk-margin-auto-vertical">

            <button class="uk-modal-close-default" type="button" data-uk-close></button>

            <div class="get-price">
                <?php
                if($ap_office_price_form == 'custom'){
                    echo do_shortcode($ap_office_form_custom);
                }else{
                    if(function_exists('wpforms')) {
                        ?>
                        <h3 class="uk-modal-title"><?php echo esc_html(get_the_title($ap_office_price_form)); ?></h3>
                        <?php
                        echo do_shortcode('[wpforms id="' . $ap_office_price_form . '"]');
                    }
                }
                ?>
            </div>

        </div>
    </div>
<?php } ?>