<?php
defined('ABSPATH') or exit();
$title = html_entity_decode(get_the_title(get_the_ID()));
$tweet_title = urlencode($title);
?>
<div class="templaza-blog-share uk-flex uk-flex-middle uk-flex-right@s uk-flex-left">
    <a class="facebook" title="<?php esc_attr_e('Share on Facebook','tzautoshowroom');?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_the_permalink(get_the_ID())); ?>">
        <i class="fab fa-facebook"></i>
    </a>
    <a class="twitter" title="<?php esc_attr_e('Share on Twitter','tzautoshowroom');?>" target="_blank" href="https://twitter.com/home?status=Check%20out%20this%20article:%20<?php print esc_attr($tweet_title); ?>%20-%20<?php echo urlencode(get_the_permalink(get_the_ID())); ?>">
        <i class="fab fa-twitter"></i>
    </a>
    <?php $templaza_pin_image = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID())); ?>
    <a class="pinterest" title="<?php esc_attr_e('Share on Pinterest','tzautoshowroom');?>"  data-pin-do="skipLink" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_attr($templaza_pin_image); ?>&description=<?php echo urlencode(get_the_title(get_the_ID())); ?>">
        <i class="fab fa-pinterest"></i>
    </a>
    <a class="linkedin" title="<?php esc_attr_e('Share on Linkedin','tzautoshowroom');?>"  target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php the_permalink(get_the_ID()); ?>">
        <i class="fab fa-linkedin"></i>
    </a>
</div>